/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.List;
import org.apache.lucene.search.Sort;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.embedded.LuceneQuery;

class EmbeddedLuceneQuery
implements LuceneQuery {
    private final SearchManager sm;
    private final LuceneQueryParsingResult parsingResult;
    private final Sort sort;
    private final long startOffset;
    private final int maxResults;
    private CacheQuery cacheQuery = null;

    public EmbeddedLuceneQuery(SearchManager sm, LuceneQueryParsingResult parsingResult, Sort sort, long startOffset, int maxResults) {
        this.sm = sm;
        this.parsingResult = parsingResult;
        this.sort = sort;
        this.startOffset = startOffset;
        this.maxResults = maxResults;
    }

    private CacheQuery getCacheQuery() {
        if (this.cacheQuery == null) {
            this.cacheQuery = this.sm.getQuery(this.parsingResult.getQuery(), this.parsingResult.getTargetEntity());
            if (this.sort != null) {
                this.cacheQuery = this.cacheQuery.sort(this.sort);
            }
            if (this.parsingResult.getProjections() != null && !this.parsingResult.getProjections().isEmpty()) {
                this.cacheQuery.projection(this.parsingResult.getProjections().toArray(new String[this.parsingResult.getProjections().size()]));
            }
            if (this.startOffset > 0L) {
                this.cacheQuery.firstResult((int)this.startOffset);
            }
            if (this.maxResults > 0) {
                this.cacheQuery.maxResults(this.maxResults);
            }
        }
        return this.cacheQuery;
    }

    @Override
    public <T> List<T> list() {
        return this.getCacheQuery().list();
    }

    @Override
    public ResultIterator iterator(FetchOptions fetchOptions) {
        return this.getCacheQuery().iterator(fetchOptions);
    }

    @Override
    public ResultIterator iterator() {
        return this.getCacheQuery().iterator();
    }

    @Override
    public int getResultSize() {
        return this.getCacheQuery().getResultSize();
    }

    public String toString() {
        return "EmbeddedLuceneQuery{parsingResult=" + this.parsingResult + ", sort=" + this.sort + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

