/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.Assert;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.LocalCacheTest")
public class LocalCacheTest
extends SingleCacheManagerTest {
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected Person person4;
    protected AnotherGrassEater anotherGrassEater;
    protected QueryParser queryParser;
    protected String key1 = "Navin";
    protected String key2 = "BigGoat";
    protected String key3 = "MiniGoat";
    protected String anotherGrassEaterKey = "anotherGrassEaterKey";

    public LocalCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testSimple() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        List found = cacheQuery.list();
        int elems = found.size();
        assert (elems == 1) : "Expected 1 but was " + elems;
        Object val = found.get(0);
        assert (val.equals(this.person1)) : "Expected " + this.person1 + " but was " + val;
    }

    public void testSimpleForNonField() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "nonSearchableField", "test1");
        List found = cacheQuery.list();
        int elems = found.size();
        assert (elems == 0) : "Expected 0 but was " + elems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEagerIterator() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
        try {
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        finally {
            found.close();
        }
    }

    public void testMultipleResults() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        AssertJUnit.assertEquals((Object)this.person2, found.get(0));
        AssertJUnit.assertEquals((Object)this.person3, found.get(1));
    }

    public void testModified() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        luceneQuery = this.queryParser.parse("pizza");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
    }

    public void testAdded() throws ParseException {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        this.loadTestingData();
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class, AnotherGrassEater.class);
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache.put((Object)"mighty", (Object)this.person4);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testRemoved() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.contains(this.person2));
        assert (found.contains(this.person3)) : "This should still contain object person3";
        this.cache.remove((Object)this.key3);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.contains(this.person2));
        assert (!found.contains(this.person3)) : "The search should not return person3";
    }

    public void testUpdated() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2)) : "The search should have person2";
        this.cache.put((Object)this.key2, (Object)this.person1);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1) : "Size of list should be 1";
        assert (!found.contains(this.person2)) : "Person 2 should not be found now";
        assert (!found.contains(this.person1)) : "Person 1 should not be found because it does not meet the search criteria";
    }

    public void testSetSort() throws ParseException {
        this.loadTestingData();
        Sort sort = new Sort(new SortField("age", 3));
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.get(0).equals(this.person3));
        assert (found.get(1).equals(this.person2));
        this.person2.setAge(10);
        this.cache.put((Object)this.key2, (Object)this.person2);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.get(0).equals(this.person2));
        assert (found.get(1).equals(this.person3));
    }

    public void testSetFilter() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        PrefixFilter filter = new PrefixFilter(new Term("blurb", "cheese"));
        cacheQuery.filter((Filter)filter);
        found = cacheQuery.list();
        assert (found.size() == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyIterator() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        try {
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        finally {
            found.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Unknown FetchMode null")
    public void testUnknownFetchModeIterator() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        ResultIterator found = cacheQuery.iterator(new FetchOptions(){

            public FetchOptions fetchMode(FetchOptions.FetchMode fetchMode) {
                return null;
            }
        });
        try {
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        finally {
            found.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorWithDefaultOptions() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        ResultIterator found = cacheQuery.iterator();
        try {
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        finally {
            found.close();
        }
    }

    public void testExplain() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        int matchCounter = 0;
        for (int i = 0; i < 4; ++i) {
            Explanation found = cacheQuery.explain(i);
            if (!found.isMatch()) continue;
            ++matchCounter;
        }
        AssertJUnit.assertEquals((int)3, (int)matchCounter);
    }

    public void testFullTextFilterOnOff() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery query = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"cheese");
        AssertJUnit.assertEquals((int)1, (int)query.getResultSize());
        List result = query.list();
        Person person = (Person)result.get(0);
        AssertJUnit.assertEquals((String)"Mini Goat", (String)person.getName());
        AssertJUnit.assertEquals((String)"Eats cheese", (String)person.getBlurb());
        query.disableFullTextFilter("personFilter");
        AssertJUnit.assertEquals((int)3, (int)query.getResultSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        ResultIterator iterator = cacheQuery.iterator();
        try {
            if (iterator.hasNext()) {
                Object next = iterator.next();
                iterator.remove();
            }
        }
        finally {
            iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyIteratorWithOffset() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        try {
            Assert.assertEquals((int)2, (int)this.countElements(iterator));
        }
        finally {
            iterator.close();
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchManagerWithNullCache() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("fish");
        CacheQuery cacheQuery = Search.getSearchManager(null).getQuery(luceneQuery, new Class[0]).firstResult(1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLazyIteratorWithInvalidFetchSize() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={NoSuchElementException.class})
    public void testLazyIteratorWithNoElementsFound() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("fish");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        try {
            found.next();
        }
        finally {
            found.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIteratorWithNullFetchMode() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(null));
        try {
            found.next();
        }
        finally {
            found.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchKeyTransformer() throws ParseException {
        SearchManager manager = Search.getSearchManager((Cache)this.cache);
        manager.registerKeyTransformer(CustomKey3.class, CustomKey3Transformer.class);
        this.loadTestingDataWithCustomKey();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = manager.getQuery(luceneQuery, new Class[0]);
        ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        try {
            Assert.assertEquals((int)3, (int)this.countElements(iterator));
        }
        finally {
            iterator.close();
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchWithWrongCache() throws ParseException {
        Cache cache = (Cache)Mockito.mock(CacheImpl.class);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn(null);
        SearchManager manager = Search.getSearchManager((Cache)cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchManagerWithInstantiation() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        Search search = new Search();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.valueOf((String)"LAZY")));
        try {
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        finally {
            found.close();
        }
    }

    public void testGetResultSize() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxResults() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).maxResults(1);
        Assert.assertEquals((int)3, (int)cacheQuery.getResultSize());
        Assert.assertEquals((int)1, (int)cacheQuery.list().size());
        ResultIterator eagerIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
        try {
            Assert.assertEquals((int)1, (int)this.countElements(eagerIterator));
        }
        finally {
            eagerIterator.close();
        }
        ResultIterator lazyIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        try {
            Assert.assertEquals((int)1, (int)this.countElements(lazyIterator));
        }
        finally {
            lazyIterator.close();
        }
        ResultIterator defaultIterator = cacheQuery.iterator();
        try {
            Assert.assertEquals((int)1, (int)this.countElements(defaultIterator));
        }
        finally {
            defaultIterator.close();
        }
    }

    private int countElements(ResultIterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public void testClear() {
        this.loadTestingData();
        Term navin = new Term("name", "navin");
        Term goat = new Term("name", "goat");
        Query[] queries = new Query[]{new TermQuery(goat), new TermQuery(navin)};
        Query luceneQuery = queries[0].combine(queries);
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 3) : "Expected 3, got " + cacheQuery.getResultSize();
        this.cache.clear();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 0);
    }

    public void testTypeFiltering() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("grass");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.containsAll(Arrays.asList(this.person2, this.anotherGrassEater)));
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        luceneQuery = this.queryParser.parse("grass");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[]{AnotherGrassEater.class});
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.anotherGrassEater));
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().indexLocalOnly(false).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testEntityDiscovery() {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        Person p = new Person();
        p.setName("Lucene developer");
        p.setAge(30);
        p.setBlurb("works best on weekends");
        this.cache.put((Object)p.getName(), (Object)p);
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class);
    }

    private void assertIndexingKnows(Cache<Object, Object> cache, Class ... types) {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        SearchFactoryImplementor searchFactoryIntegrator = (SearchFactoryImplementor)cr.getComponent(SearchFactoryIntegrator.class);
        Assert.assertNotNull((Object)searchFactoryIntegrator);
        Map indexBindingForEntity = searchFactoryIntegrator.getIndexBindingForEntity();
        Assert.assertNotNull((Object)indexBindingForEntity);
        Set keySet = indexBindingForEntity.keySet();
        Assert.assertEquals((int)types.length, (int)keySet.size());
        Assert.assertTrue((boolean)keySet.containsAll(Arrays.asList(types)));
    }

    protected void loadTestingData() {
        this.prepareTestingData();
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
    }

    protected void loadTestingDataWithCustomKey() {
        this.prepareTestingData();
        CustomKey3 customeKey1 = new CustomKey3(this.key1);
        CustomKey3 customeKey2 = new CustomKey3(this.key2);
        CustomKey3 customeKey3 = new CustomKey3(this.key3);
        this.cache.put((Object)customeKey1, (Object)this.person1);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
    }

    protected void prepareTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setAge(20);
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setNonSearchableField("test1");
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setAge(30);
        this.person2.setBlurb("Eats grass");
        this.person2.setNonSearchableField("test2");
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setAge(25);
        this.person3.setBlurb("Eats cheese");
        this.person3.setNonSearchableField("test3");
        this.anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
    }

    protected void enhanceConfig(ConfigurationBuilder c) {
    }
}

