/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.LuceneQuery;
import org.infinispan.query.dsl.embedded.sample_domain_model.User;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.QueryDslIterationTest")
public class QueryDslIterationTest
extends AbstractQueryDslTest {
    @BeforeMethod
    private void populateCache() throws Exception {
        User user1 = new User();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("White");
        User user2 = new User();
        user2.setId(2);
        user2.setName("Jack");
        user2.setSurname("Black");
        User user3 = new User();
        user3.setId(3);
        user3.setName("John");
        user3.setSurname("Brown");
        User user4 = new User();
        user4.setId(4);
        user4.setName("Michael");
        user4.setSurname("Black");
        this.cache.put((Object)("user_" + user1.getId()), (Object)user1);
        this.cache.put((Object)("user_" + user2.getId()), (Object)user2);
        this.cache.put((Object)("user_" + user3.getId()), (Object)user3);
        this.cache.put((Object)("user_" + user4.getId()), (Object)user4);
    }

    public void testOrderByAsc() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).orderBy("name", SortOrder.ASC).build();
        AssertJUnit.assertEquals((int)4, (int)q.getResultSize());
        List list = q.list();
        AssertJUnit.assertEquals((int)4, (int)list.size());
        this.checkNamesAsc(list);
    }

    private void checkNamesAsc(List<User> list) {
        String prevName = null;
        for (User u : list) {
            AssertJUnit.assertNotNull((Object)u.getName());
            if (prevName != null) {
                AssertJUnit.assertTrue((u.getName().compareTo(prevName) >= 0 ? 1 : 0) != 0);
            }
            prevName = u.getName();
        }
    }

    public void testOrderByDesc() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).orderBy("surname", SortOrder.DESC).build();
        AssertJUnit.assertEquals((int)4, (int)q.getResultSize());
        List list = q.list();
        AssertJUnit.assertEquals((int)4, (int)list.size());
        String prevName = null;
        for (User u : list) {
            AssertJUnit.assertNotNull((Object)u.getSurname());
            if (prevName != null) {
                AssertJUnit.assertTrue((u.getSurname().compareTo(prevName) <= 0 ? 1 : 0) != 0);
            }
            prevName = u.getSurname();
        }
    }

    public void testMaxResults() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).orderBy("name", SortOrder.ASC).maxResults(2).build();
        AssertJUnit.assertEquals((int)4, (int)q.getResultSize());
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        this.checkNamesAsc(list);
    }

    public void testStartOffset() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).orderBy("name", SortOrder.ASC).startOffset(2L).build();
        AssertJUnit.assertEquals((int)4, (int)q.getResultSize());
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        this.checkNamesAsc(list);
    }

    public void testProjection1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).setProjection(new String[]{"id", "name"}).build();
        AssertJUnit.assertEquals((int)4, (int)q.getResultSize());
        List list = q.list();
        AssertJUnit.assertEquals((int)4, (int)list.size());
        for (Object[] u : list) {
            AssertJUnit.assertNotNull((Object)u[1]);
            AssertJUnit.assertTrue((boolean)(u[0] instanceof Integer));
        }
    }

    public void testIteration1() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator());
    }

    public void testIteration2() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(1)));
    }

    public void testIteration3() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(3)));
    }

    public void testIteration4() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER).fetchSize(1)));
    }

    public void testIteration5() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER).fetchSize(3)));
    }

    private LuceneQuery getIterationQuery() {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        QueryBuilder queryQueryBuilder = qf.from(User.class).not().having("surname").eq((Object)"Blue").toBuilder();
        return (LuceneQuery)queryQueryBuilder.build();
    }

    private void checkIterator(int expected, ResultIterator iterator) {
        int elements = 0;
        while (iterator.hasNext()) {
            User u = (User)iterator.next();
            AssertJUnit.assertNotNull((Object)u.getName());
            AssertJUnit.assertNotNull((Object)u.getSurname());
            ++elements;
        }
        AssertJUnit.assertEquals((int)expected, (int)elements);
    }
}

