/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.analysis;

import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.util.AnalyzerUtils;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.analysis.Team;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.analysis.SolrAnalyzerTest")
public class SolrAnalyzerTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().indexLocalOnly(false).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testAnalyzerDef() throws Exception {
        Team team = new Team();
        team.setDescription("This is a D\u00e0scription");
        team.setLocation("Atlanta");
        team.setName("ATL team");
        this.cache.put((Object)"id", (Object)team);
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        TermQuery query = new TermQuery(new Term("description", "D\u00e0scription"));
        Assert.assertEquals((String)"iso latin filter should work.  \ufffd should be a now", (int)0, (int)searchManager.getQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "is"));
        Assert.assertEquals((String)"stop word filter should work. is should be removed", (int)0, (int)searchManager.getQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "dascript"));
        Assert.assertEquals((String)"snowball stemmer should work. 'dascription' should be stemmed to 'dascript'", (int)1, (int)searchManager.getQuery((Query)query, new Class[0]).list().size());
    }

    public void testAnalyzers() throws Exception {
        SearchManager search = Search.getSearchManager((Cache)this.cache);
        Analyzer analyzer = search.getSearchFactory().getAnalyzer("standard_analyzer");
        String text = "This is just FOOBAR's";
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "just", "FOOBAR's"});
        analyzer = search.getSearchFactory().getAnalyzer("html_standard_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "foobar's"});
        analyzer = search.getSearchFactory().getAnalyzer("html_whitespace_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "foobar's"});
        analyzer = search.getSearchFactory().getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"abc", "abcd", "abcde"});
        analyzer = search.getSearchFactory().getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"abc", "abcd", "abcde"});
        analyzer = search.getSearchFactory().getAnalyzer("porter_analyzer");
        text = "bikes bikes biking";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"bike", "bike", "bike"});
        analyzer = search.getSearchFactory().getAnalyzer("word_analyzer");
        text = "CamelCase";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"Camel", "Case"});
        analyzer = search.getSearchFactory().getAnalyzer("synonym_analyzer");
        text = "ipod cosmos";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"ipod", "i-pod", "universe", "cosmos"});
        analyzer = search.getSearchFactory().getAnalyzer("shingle_analyzer");
        text = "please divide this sentence into shingles";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"please", "please divide", "divide", "divide this", "this", "this sentence", "sentence", "sentence into", "into", "into shingles", "shingles"});
        analyzer = search.getSearchFactory().getAnalyzer("pattern_analyzer");
        text = "foo,bar";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"foo", "bar"});
        analyzer = search.getSearchFactory().getAnalyzer("mapping_char_analyzer");
        text = "CORA\u00c7\u00c3O DE MEL\u00c3O";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"CORACAO", "DE", "MELAO"});
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Team.class};
    }

    private static void assertTokensEqual(Token[] tokens, String[] strings) {
        Assert.assertEquals((int)strings.length, (int)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            Assert.assertEquals((String)("index " + i), (String)strings[i], (String)AnalyzerUtils.getTermText((Token)tokens[i]));
        }
    }
}

