/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.CustomQueryCommand;

public final class CommandInitializer
implements ModuleCommandInitializer {
    private Cache<?, ?> cache;
    private SearchFactoryImplementor searchFactoryImplementor;
    private QueryInterceptor queryInterceptor;
    private EmbeddedCacheManager cacheManager;

    public void setCache(Cache<?, ?> cache, EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.cache = cache;
        SearchManager searchManager = Search.getSearchManager(cache);
        SearchFactory searchFactory = searchManager.getSearchFactory();
        this.searchFactoryImplementor = (SearchFactoryImplementor)searchFactory;
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
    }

    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        CustomQueryCommand queryCommand = (CustomQueryCommand)c;
        queryCommand.fetchExecutionContext(this);
    }

    public final SearchFactoryImplementor getSearchFactory() {
        return this.searchFactoryImplementor;
    }

    public final QueryInterceptor getQueryInterceptor() {
        return this.queryInterceptor;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }
}

