/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.Properties;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.infinispan.query.indexmanager.InfinispanCommandsBackend;
import org.infinispan.query.indexmanager.MasterSwitchDelegatingQueueProcessor;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexManager
extends DirectoryBasedIndexManager {
    private static final Log log = (Log)LogFactory.getLog(InfinispanIndexManager.class, Log.class);
    private InfinispanCommandsBackend remoteMaster;

    protected BackendQueueProcessor createBackend(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        BackendQueueProcessor localMaster = BackendFactory.createBackend((DirectoryBasedIndexManager)this, (WorkerBuildContext)buildContext, (Properties)cfg);
        this.remoteMaster = new InfinispanCommandsBackend();
        this.remoteMaster.initialize(cfg, buildContext, this);
        MasterSwitchDelegatingQueueProcessor joinedMaster = new MasterSwitchDelegatingQueueProcessor(localMaster, this.remoteMaster);
        return joinedMaster;
    }

    protected DirectoryProvider createDirectoryProvider(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        String directoryOption = cfg.getProperty("directory_provider", null);
        if (directoryOption != null && !"infinispan".equals(directoryOption)) {
            log.ignoreDirectoryProviderProperty(indexName, directoryOption);
        }
        InfinispanDirectoryProvider infinispanDP = new InfinispanDirectoryProvider();
        infinispanDP.initialize(indexName, cfg, (BuildContext)buildContext);
        return infinispanDP;
    }

    public InfinispanCommandsBackend getRemoteMaster() {
        return this.remoteMaster;
    }
}

