/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.jmx;

import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.jmx.QueryMBeanTest")
public class QueryMBeanTest
extends SingleCacheManagerTest {
    static final String JMX_DOMAIN = QueryMBeanTest.class.getSimpleName();
    static final String CACHE_NAME = "queryable-cache";
    MBeanServer server;
    private int numberOfEntries = 100;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)JMX_DOMAIN);
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.indexing().enable().indexLocalOnly(false).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        cm.defineConfiguration(CACHE_NAME, builder.build());
        return cm;
    }

    protected void setup() throws Exception {
        super.setup();
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
    }

    public void testQueryStatsMBean() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName name = this.getQueryStatsObjectName(JMX_DOMAIN, CACHE_NAME);
        assert (this.server.isRegistered(name));
        assert (!((Boolean)this.server.getAttribute(name, "StatisticsEnabled")).booleanValue());
        this.server.setAttribute(name, new Attribute("StatisticsEnabled", true));
        assert (((Boolean)this.server.getAttribute(name, "StatisticsEnabled")).booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryStats() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName name = this.getQueryStatsObjectName(JMX_DOMAIN, CACHE_NAME);
        try {
            assert (this.server.isRegistered(name));
            if (!((Boolean)this.server.getAttribute(name, "StatisticsEnabled")).booleanValue()) {
                this.server.setAttribute(name, new Attribute("StatisticsEnabled", true));
            }
            this.prepareTestingData();
            Cache cache = this.cacheManager.getCache(CACHE_NAME);
            QueryParser queryParser = TestQueryHelperFactory.createQueryParser("blurb");
            Query luceneQuery = queryParser.parse("value");
            CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(luceneQuery, new Class[0]);
            List found = cacheQuery.list();
            Assert.assertEquals((long)this.numberOfEntries, (long)found.size());
            Assert.assertEquals((Object)this.numberOfEntries, (Object)this.server.invoke(name, "getNumberOfIndexedEntities", new Object[]{Person.class.getCanonicalName()}, new String[]{String.class.getCanonicalName()}));
            Assert.assertEquals((Object)1, (Object)this.server.invoke(name, "getNumberOfIndexedEntities", new Object[]{AnotherGrassEater.class.getCanonicalName()}, new String[]{String.class.getCanonicalName()}));
            Set classNames = (Set)this.server.getAttribute(name, "IndexedClassNames");
            Assert.assertEquals((long)2L, (long)classNames.size());
            Assert.assertTrue((String)"The set should contain the Person class name.", (boolean)classNames.contains(Person.class.getCanonicalName()));
            Assert.assertTrue((String)"The set should contain the AnotherGrassEater class name.", (boolean)classNames.contains(AnotherGrassEater.class.getCanonicalName()));
        }
        finally {
            this.server.setAttribute(name, new Attribute("StatisticsEnabled", false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJmxUnregistration() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName queryStatsObjectName = this.getQueryStatsObjectName(JMX_DOMAIN, CACHE_NAME);
        Set<ObjectName> matchingNames = this.server.queryNames(new ObjectName(JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
        Assert.assertEquals((long)1L, (long)matchingNames.size());
        Assert.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
        EmbeddedCacheManager cm2 = null;
        try {
            ConfigurationBuilder defaultCacheConfig2 = new ConfigurationBuilder();
            defaultCacheConfig2.indexing().enable().addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT").jmxStatistics().enable();
            cm2 = TestCacheManagerFactory.createClusteredCacheManagerEnforceJmxDomain((String)"cm2", (String)JMX_DOMAIN, (boolean)true, (boolean)true, (ConfigurationBuilder)defaultCacheConfig2, (MBeanServerLookup)new PerThreadMBeanServerLookup());
            cm2.getCache(CACHE_NAME);
            matchingNames = this.server.queryNames(new ObjectName(JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
            Assert.assertEquals((long)2L, (long)matchingNames.size());
            Assert.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm2});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm2});
        matchingNames = this.server.queryNames(new ObjectName(JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
        Assert.assertEquals((long)1L, (long)matchingNames.size());
        Assert.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
    }

    private void prepareTestingData() {
        Cache cache = this.cacheManager.getCache(CACHE_NAME);
        for (int i = 0; i < this.numberOfEntries; ++i) {
            Person person = new Person();
            person.setName("key" + i);
            person.setAge(i);
            person.setBlurb("value " + i);
            person.setNonSearchableField("i: " + i);
            cache.put((Object)("key" + i), (Object)person);
        }
        AnotherGrassEater anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
        cache.put((Object)"key101", (Object)anotherGrassEater);
    }

    private ObjectName getQueryStatsObjectName(String jmxDomain, String cacheName) {
        String cacheManagerName = this.cacheManager.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
        try {
            return new ObjectName(jmxDomain + ":type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName) + ",component=Statistics");
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Malformed object name", (Throwable)e);
        }
    }
}

