/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.queryParser.ParseException;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="query.config.DeclarativeConfigTest", groups={"functional"})
public class DeclarativeConfigTest
extends SingleCacheManagerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:6.0 http://www.infinispan.org/schemas/infinispan-config-6.0.xsd\"\n      xmlns=\"urn:infinispan:config:6.0\">\n   <default>\n      <indexing enabled=\"true\" indexLocalOnly=\"true\">\n         <properties>\n            <property name=\"default.directory_provider\" value=\"ram\" />\n            <property name=\"lucene_version\" value=\"LUCENE_CURRENT\" />\n         </properties>\n      </indexing>\n   </default>\n</infinispan>";
        System.out.println("Using test configuration:\n\n" + config + "\n");
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        try {
            this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        finally {
            ((InputStream)is).close();
        }
        this.cache = this.cacheManager.getCache();
        return this.cacheManager;
    }

    public void simpleIndexTest() throws ParseException {
        this.cache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(this.cache, "name", "Name");
        Assert.assertEquals((int)1, (int)cq.getResultSize());
        List l = cq.list();
        Assert.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        Assert.assertEquals((String)"A Person's Name", (String)p.getName());
        Assert.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        Assert.assertEquals((int)75, (int)p.getAge());
    }

    @Test(dependsOnMethods={"simpleIndexTest"})
    public void testPropertiesWhereRead() {
        SearchFactoryIntegrator searchFactory = TestQueryHelperFactory.extractSearchFactory(this.cache);
        EntityIndexBinding indexBindingForEntity = searchFactory.getIndexBinding(Person.class);
        IndexManager[] managers = indexBindingForEntity.getIndexManagers();
        Assert.assertEquals((int)1, (int)managers.length);
        Assert.assertNotNull((Object)managers[0]);
        Assert.assertTrue((boolean)(managers[0] instanceof DirectoryBasedIndexManager));
        DirectoryBasedIndexManager dbim = (DirectoryBasedIndexManager)managers[0];
        Assert.assertTrue((boolean)(dbim.getDirectoryProvider() instanceof RAMDirectoryProvider));
    }
}

