/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredQueryTest")
public class ClusteredQueryTest
extends MultipleCacheManagersTest {
    Cache<String, Person> cacheAMachine1;
    Cache<String, Person> cacheAMachine2;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    QueryParser queryParser;
    Query luceneQuery;
    CacheQuery cacheQuery;
    final String key1 = "Navin";
    final String key2 = "BigGoat";
    final String key3 = "MiniGoat";

    public ClusteredQueryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void enhanceConfig(ConfigurationBuilder cacheCfg) {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredQueryTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        cacheCfg.indexing().enable().indexLocalOnly(true).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.enhanceConfig(cacheCfg);
        List caches = this.createClusteredCaches(2, cacheCfg);
        this.cacheAMachine1 = (Cache)caches.get(0);
        this.cacheAMachine2 = (Cache)caches.get(1);
    }

    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    protected void prepareTestData() {
        this.person1 = new Person();
        this.person1.setName("NavinSurtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(45);
        this.person2 = new Person();
        this.person2.setName("BigGoat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(30);
        this.person3 = new Person();
        this.person3.setName("MiniGoat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(35);
        this.cacheAMachine2.put((Object)"Navin", (Object)this.person1);
        this.cacheAMachine1.put((Object)"BigGoat", (Object)this.person2);
        this.cacheAMachine1.put((Object)"MiniGoat", (Object)this.person3);
        this.person4 = new Person();
        this.person4.setName("MightyGoat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(66);
        this.cacheAMachine1.put((Object)"newOne", (Object)this.person4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyOrdered() throws ParseException {
        this.populateCache();
        SortField sortField = new SortField("age", 4);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        for (int i = 0; i < 2; ++i) {
            ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
            try {
                assert (this.cacheQuery.getResultSize() == 4) : this.cacheQuery.getResultSize();
                int previousAge = 0;
                while (iterator.hasNext()) {
                    Person person = (Person)iterator.next();
                    assert (person.getAge() > previousAge);
                    previousAge = person.getAge();
                }
                continue;
            }
            finally {
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyNonOrdered() throws ParseException {
        this.populateCache();
        ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        try {
            assert (this.cacheQuery.getResultSize() == 4) : this.cacheQuery.getResultSize();
        }
        finally {
            iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEagerOrdered() throws ParseException {
        this.populateCache();
        SortField sortField = new SortField("age", 4);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
        try {
            assert (this.cacheQuery.getResultSize() == 4) : this.cacheQuery.getResultSize();
            int previousAge = 0;
            while (iterator.hasNext()) {
                Person person = (Person)iterator.next();
                assert (person.getAge() > previousAge);
                previousAge = person.getAge();
            }
        }
        finally {
            iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={NoSuchElementException.class}, expectedExceptionsMessageRegExp="Out of boundaries")
    public void testIteratorNextOutOfBounds() throws Exception {
        this.populateCache();
        this.cacheQuery.maxResults(1);
        ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
        try {
            assert (iterator.hasNext());
            iterator.next();
            assert (!iterator.hasNext());
            iterator.next();
        }
        finally {
            iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() throws Exception {
        this.populateCache();
        this.cacheQuery.maxResults(1);
        ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
        try {
            assert (iterator.hasNext());
            iterator.remove();
        }
        finally {
            iterator.close();
        }
    }

    public void testList() throws ParseException {
        this.populateCache();
        SortField sortField = new SortField("age", 4);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        List results = this.cacheQuery.list();
        assert (results.size() == 4) : this.cacheQuery.getResultSize();
        int previousAge = 0;
        for (Object result : results) {
            Person person = (Person)result;
            assert (person.getAge() > previousAge);
            previousAge = person.getAge();
        }
    }

    public void testGetResultSizeList() throws ParseException {
        this.populateCache();
        assert (this.cacheQuery.getResultSize() == 4) : this.cacheQuery.getResultSize();
    }

    public void testPagination() throws ParseException {
        this.populateCache();
        this.cacheQuery.firstResult(2);
        this.cacheQuery.maxResults(1);
        SortField sortField = new SortField("age", 4);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        List results = this.cacheQuery.list();
        assert (results.size() == 1);
        assert (this.cacheQuery.getResultSize() == 4);
        assert (((Person)results.get(0)).getAge() == 45);
    }

    private void populateCache() throws ParseException {
        this.prepareTestData();
        Query[] queries = new Query[2];
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        queries[0] = this.luceneQuery = this.queryParser.parse("eats");
        queries[1] = this.luceneQuery = this.queryParser.parse("playing");
        this.luceneQuery = this.luceneQuery.combine(queries);
        this.cacheQuery = Search.getSearchManager(this.cacheAMachine1).getClusteredQuery(this.luceneQuery, new Class[0]);
    }
}

