/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.AdvancedCache;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.impl.QueryResultLoader;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.InvalidIteratorTest")
public class InvalidIteratorTest {
    private List<EntityInfo> entityInfos = new ArrayList<EntityInfo>();
    private AdvancedCache<String, String> cache;

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLazyIteratorInitWithInvalidFetchSize() throws IOException {
        DocumentExtractor extractor = (DocumentExtractor)Mockito.mock(DocumentExtractor.class);
        Mockito.when((Object)extractor.extract(Matchers.anyInt())).thenAnswer((Answer)new Answer<EntityInfo>(){

            public EntityInfo answer(InvocationOnMock invocation) throws Throwable {
                int index = (Integer)invocation.getArguments()[0];
                return (EntityInfo)InvalidIteratorTest.this.entityInfos.get(index);
            }
        });
        this.cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        new LazyIterator(extractor, (QueryResultLoader)new EntityLoader(this.cache, new KeyTransformationHandler()), this.getFetchSize());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEagerIteratorInitWithInvalidFetchSize() throws IOException {
        this.cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        new EagerIterator(this.entityInfos, (QueryResultLoader)new EntityLoader(this.cache, new KeyTransformationHandler()), this.getFetchSize());
    }

    private int getFetchSize() {
        return 0;
    }
}

