/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.infinispan.query.impl.NullFilteringIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.impl.NullFilteringIteratorTest")
public class NullFilteringIteratorTest {
    @Test
    public void testEmptyIteratorReturnsFalseOnHasNext() {
        NullFilteringIterator<Object> iterator = this.getIterator(new Object[0]);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEmptyIteratorThrowsExceptionOnNext() {
        NullFilteringIterator<Object> iterator = this.getIterator(new Object[0]);
        try {
            iterator.next();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testNonNullValue() {
        NullFilteringIterator<String> iterator = this.getIterator("foo");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNullValue() {
        NullFilteringIterator<String> iterator = this.getIterator(new String[]{null});
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testSingleNullValue() {
        NullFilteringIterator<String> iterator = this.getIterator(null, "foo");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMultipleConsecutiveNullValues() {
        NullFilteringIterator<String> iterator = this.getIterator(null, null, null, "foo");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNullValueAtTheEnd() {
        NullFilteringIterator<String> iterator = this.getIterator("foo", null);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMultipleNullValuesAtTheEnd() {
        NullFilteringIterator<String> iterator = this.getIterator("foo", null, null, null);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNextOnly() {
        NullFilteringIterator<String> iterator = this.getIterator(null, "foo", null, "bar", null);
        Assert.assertEquals((String)((String)iterator.next()), (String)"foo");
        Assert.assertEquals((String)((String)iterator.next()), (String)"bar");
        try {
            iterator.next();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testHasNextDoesNotAdvanceIterator() {
        NullFilteringIterator<String> iterator = this.getIterator("foo");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private <E> NullFilteringIterator<E> getIterator(E ... elements) {
        return new NullFilteringIterator(Arrays.asList(elements).iterator());
    }
}

