/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.performance;

import java.io.IOException;
import java.lang.reflect.Field;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.performance.TuningOptionsAppliedTest")
public class TuningOptionsAppliedTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyFSDirectoryOptions() throws IOException {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml((String)"nrt-performance-writer.xml");
        try {
            SearchFactoryImplementor si = this.extractSearchFactoryImplementor(embeddedCacheManager);
            NRTIndexManager nrti = this.verifyShardingOptions(si, 6);
            this.verifyIndexWriterOptions(nrti, 220, 4096, 30);
            this.verifyUsesFSDirectory(nrti);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyInfinispanDirectoryOptions() throws IOException, IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml((String)"nrt-performance-writer-infinispandirectory.xml");
        try {
            SearchFactoryImplementor si = this.extractSearchFactoryImplementor(embeddedCacheManager);
            NRTIndexManager nrti = this.verifyShardingOptions(si, 6);
            this.verifyIndexWriterOptions(nrti, 64, 1024, 30);
            this.verifyUsesInfinispanDirectory(nrti, 128000, embeddedCacheManager);
            embeddedCacheManager.getCache("Indexed").stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
    }

    private SearchFactoryImplementor extractSearchFactoryImplementor(EmbeddedCacheManager embeddedCacheManager) {
        Cache cache = embeddedCacheManager.getCache("Indexed");
        cache.put((Object)"hey this type exists", (Object)new Person("id", "name", 3));
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        return (SearchFactoryImplementor)searchManager.getSearchFactory();
    }

    private NRTIndexManager verifyShardingOptions(SearchFactoryImplementor searchFactory, int expectedShards) {
        IndexManagerHolder allIndexesManager = searchFactory.getIndexManagerHolder();
        for (int i = 0; i < expectedShards; ++i) {
            Assert.assertNotNull((Object)allIndexesManager.getIndexManager("person." + i), (String)("person." + i + " IndexManager missing!"));
        }
        Assert.assertNull((Object)allIndexesManager.getIndexManager("person." + expectedShards), (String)"An IndexManager too much was created!");
        IndexManager indexManager = allIndexesManager.getIndexManager("person.0");
        Assert.assertTrue((boolean)(indexManager instanceof NRTIndexManager));
        NRTIndexManager nrtIM = (NRTIndexManager)indexManager;
        return nrtIM;
    }

    private void verifyUsesFSDirectory(NRTIndexManager nrtIM) {
        DirectoryProvider directoryProvider = nrtIM.getDirectoryProvider();
        Assert.assertTrue((boolean)(directoryProvider instanceof FSDirectoryProvider));
    }

    private void verifyUsesInfinispanDirectory(NRTIndexManager nrti, int expectedChunkSize, EmbeddedCacheManager embeddedCacheManager) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        DirectoryProvider directoryProvider = nrti.getDirectoryProvider();
        Assert.assertTrue((boolean)(directoryProvider instanceof InfinispanDirectoryProvider));
        InfinispanDirectoryProvider ispn = (InfinispanDirectoryProvider)directoryProvider;
        InfinispanDirectory infinispanDirectory = ispn.getDirectory();
        int chunkSize = this.extractFieldfromInfinispanDirectory("chunkSize").getInt(infinispanDirectory);
        Assert.assertEquals((int)chunkSize, (int)expectedChunkSize);
        AdvancedCache metadataCache = (AdvancedCache)this.extractFieldfromInfinispanDirectory("metadataCache").get(infinispanDirectory);
        Assert.assertEquals((String)metadataCache.getName(), (String)"LuceneIndexesMetadataOWR");
        AdvancedCache chunksCache = (AdvancedCache)this.extractFieldfromInfinispanDirectory("chunksCache").get(infinispanDirectory);
        Assert.assertEquals((String)chunksCache.getName(), (String)"LuceneIndexesDataOWR");
        Assert.assertTrue((chunksCache.getCacheManager() == embeddedCacheManager ? 1 : 0) != 0);
    }

    private Field extractFieldfromInfinispanDirectory(String fieldName) throws SecurityException, NoSuchFieldException {
        Field field = InfinispanDirectory.class.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    private void verifyIndexWriterOptions(NRTIndexManager nrtIM, Integer expectedRAMBuffer, Integer expectedMaxMergeSize, Integer expectedMergeFactor) {
        LuceneIndexingParameters indexingParameters = nrtIM.getIndexingParameters();
        LuceneIndexingParameters.ParameterSet indexParameters = indexingParameters.getIndexParameters();
        Assert.assertEquals((Object)indexParameters.getCurrentValueFor(IndexWriterSetting.RAM_BUFFER_SIZE), (Object)expectedRAMBuffer);
        Assert.assertEquals((Object)indexParameters.getCurrentValueFor(IndexWriterSetting.MERGE_MAX_SIZE), (Object)expectedMaxMergeSize);
        Assert.assertEquals((Object)indexParameters.getCurrentValueFor(IndexWriterSetting.MERGE_FACTOR), (Object)expectedMergeFactor);
    }
}

