/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import java.util.HashMap;
import junit.framework.Assert;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.api.AnotherTestEntity;
import org.infinispan.query.api.NotIndexedType;
import org.infinispan.query.api.TestEntity;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.api.PutAllTest")
@CleanupAfterMethod
public class PutAllTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().indexLocalOnly(false).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testOverwriteNotIndexedValue() {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new NotIndexedType("name1"));
        HashMap<Long, TestEntity> map = new HashMap<Long, TestEntity>();
        map.put(10L, new TestEntity("name2", "surname2", 10L, "note"));
        this.cache.putAll(map);
        CacheQuery q1 = this.queryByNameField("name2", AnotherTestEntity.class);
        Assert.assertEquals((int)1, (int)q1.getResultSize());
        Assert.assertEquals(TestEntity.class, q1.list().get(0).getClass());
    }

    public void testAsyncOverwriteNotIndexedValue() throws Exception {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new NotIndexedType("name1"));
        HashMap<Long, TestEntity> map = new HashMap<Long, TestEntity>();
        map.put(10L, new TestEntity("name2", "surname2", 10L, "note"));
        NotifyingFuture futureTask = this.cache.putAllAsync(map);
        futureTask.get();
        Assert.assertTrue((boolean)futureTask.isDone());
        CacheQuery q1 = this.queryByNameField("name2", AnotherTestEntity.class);
        Assert.assertEquals((int)1, (int)q1.getResultSize());
        Assert.assertEquals(TestEntity.class, q1.list().get(0).getClass());
    }

    public void testOverwriteWithNonIndexedValue() {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new TestEntity("name1", "surname1", 10L, "note"));
        CacheQuery q1 = this.queryByNameField("name1", TestEntity.class);
        Assert.assertEquals((int)1, (int)q1.getResultSize());
        Assert.assertEquals(TestEntity.class, q1.list().get(0).getClass());
        HashMap<Long, NotIndexedType> map = new HashMap<Long, NotIndexedType>();
        map.put(10L, new NotIndexedType("name2"));
        this.cache.putAll(map);
        CacheQuery q2 = this.queryByNameField("name1", TestEntity.class);
        Assert.assertEquals((int)0, (int)q2.getResultSize());
        CacheQuery q3 = this.queryByNameField("name2", TestEntity.class);
        Assert.assertEquals((int)0, (int)q3.getResultSize());
    }

    public void testAsyncOverwriteWithNonIndexedValue() throws Exception {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new TestEntity("name1", "surname1", 10L, "note"));
        CacheQuery q1 = this.queryByNameField("name1", TestEntity.class);
        Assert.assertEquals((int)1, (int)q1.getResultSize());
        Assert.assertEquals(TestEntity.class, q1.list().get(0).getClass());
        HashMap<Long, NotIndexedType> map = new HashMap<Long, NotIndexedType>();
        map.put(10L, new NotIndexedType("name2"));
        NotifyingFuture futureTask = this.cache.putAllAsync(map);
        futureTask.get();
        Assert.assertTrue((boolean)futureTask.isDone());
        CacheQuery q2 = this.queryByNameField("name1", TestEntity.class);
        Assert.assertEquals((int)0, (int)q2.getResultSize());
        CacheQuery q3 = this.queryByNameField("name2", TestEntity.class);
        Assert.assertEquals((int)0, (int)q3.getResultSize());
    }

    public void testOverwriteIndexedValue() {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new TestEntity("name1", "surname1", 10L, "note"));
        CacheQuery q1 = this.queryByNameField("name1", TestEntity.class);
        Assert.assertEquals((int)1, (int)q1.getResultSize());
        Assert.assertEquals(TestEntity.class, q1.list().get(0).getClass());
        HashMap<Long, AnotherTestEntity> map = new HashMap<Long, AnotherTestEntity>();
        map.put(10L, new AnotherTestEntity("name2"));
        this.cache.putAll(map);
        CacheQuery q2 = this.queryByNameField("name1", TestEntity.class);
        Assert.assertEquals((int)0, (int)q2.getResultSize());
        CacheQuery q3 = this.queryByNameField("name2", AnotherTestEntity.class);
        Assert.assertEquals((int)1, (int)q3.getResultSize());
        Assert.assertEquals(AnotherTestEntity.class, q3.list().get(0).getClass());
    }

    private CacheQuery queryByNameField(String name, Class<?> entity) {
        SearchManager sm = Search.getSearchManager((Cache)this.cache);
        Query query = sm.buildQueryBuilderForClass(entity).get().keyword().onField("name").matching((Object)name).createQuery();
        return sm.getQuery(query, new Class[0]);
    }
}

