/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.query.SearchManager;
import org.infinispan.query.SecurityActions;
import org.infinispan.query.impl.SearchManagerImpl;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;

public class Search {
    public static SearchManager getSearchManager(Cache<?, ?> cache) {
        if (cache == null || cache.getAdvancedCache() == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        Search.ensureAccessPermissions(cache.getAdvancedCache());
        return new SearchManagerImpl(cache.getAdvancedCache());
    }

    private static void ensureAccessPermissions(AdvancedCache<?, ?> cache) {
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
    }
}

