/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.queries.faceting.Car;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.ClusteredQueryMassIndexingTest")
public class ClusteredQueryMassIndexingTest
extends DistributedMassIndexingTest {
    @Override
    protected void verifyFindsCar(Cache cache, int expectedCount, String carMake) {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("make");
        try {
            Query luceneQuery = queryParser.parse(carMake);
            CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getClusteredQuery(luceneQuery, new Class[]{Car.class});
            Assert.assertEquals((int)expectedCount, (int)cacheQuery.getResultSize());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            Assert.fail((String)("Failed due to: " + ex.getMessage()));
        }
    }

    @Override
    @Test(groups={"unstable"})
    public void testReindexing() throws Exception {
        super.testReindexing();
    }
}

