/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.query.api.NotIndexedType;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.queries.faceting.Car;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="query.distributed.MassIndexingTest", description="Unstable, see https://issues.jboss.org/browse/ISPN-4012")
public class MassIndexingTest
extends DistributedMassIndexingTest {
    @Override
    @Test(groups={"unstable"})
    public void testReindexing() throws Exception {
        for (int i = 0; i < 200; ++i) {
            ((Cache)this.caches.get(i % 2)).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).put(this.key("F" + i + "NUM"), (Object)new Car(i % 2 == 0 ? "megane" : "bmw", "blue", 300 + i));
        }
        ((Cache)this.caches.get(0)).getAdvancedCache().put(this.key("FNonIndexed1NUM"), (Object)new NotIndexedType("test1"));
        ((Cache)this.caches.get(0)).getAdvancedCache().put(this.key("FNonIndexed2NUM"), (Object)new NotIndexedType("test2"));
        this.verifyFindsCar(0, "megane");
        this.verifyFindsCar(0, "test1");
        this.verifyFindsCar(0, "test2");
        ((Cache)this.caches.get(0)).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).put(this.key("FNonIndexed3NUM"), (Object)new NotIndexedType("test3"));
        this.verifyFindsCar(0, "test3");
        this.rebuildIndexes();
        this.verifyFindsCar(100, "megane");
        this.verifyFindsCar(0, "test1");
        this.verifyFindsCar(0, "test2");
    }
}

