/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.io.File;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.FilesystemQueryDslConditionsTest")
@CleanupAfterTest
public class FilesystemQueryDslConditionsTest
extends QueryDslConditionsTest {
    private final String indexDirectory = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "filesystem").addProperty("default.indexBase", this.indexDirectory).addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    protected void setup() throws Exception {
        TestingUtil.recursiveFileRemove((String)this.indexDirectory);
        boolean created = new File(this.indexDirectory).mkdirs();
        Assert.assertTrue((boolean)created);
        super.setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try {
            super.teardown();
        }
        finally {
            TestingUtil.recursiveFileRemove((String)this.indexDirectory);
        }
    }
}

