/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.persistence;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.query.statetransfer.BaseReIndexingTest;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="query.persistence.SharedCacheLoaderQueryIndexTest", description="See ISPN-4048 -- original group: functional")
public class SharedCacheLoaderQueryIndexTest
extends BaseReIndexingTest {
    @Override
    protected void configureCache(ConfigurationBuilder builder) {
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.clustering().stateTransfer().fetchInMemoryState(false).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).preload(true)).storeName(((Object)((Object)this)).getClass().getName());
    }

    public void testPreloadIndexingAfterAddingNewNode() throws Exception {
        this.loadCacheEntries((Cache<String, Person>)((Cache)this.caches().get(0)));
        for (CacheLoader cs : TestingUtil.cachestores((List)this.caches())) {
            assert (cs.contains((Object)this.persons[0].getName())) : "Cache misconfigured, maybe cache store not pointing to same place, maybe passivation on...etc";
            DummyInMemoryStore dimcs = (DummyInMemoryStore)cs;
            assert ((Integer)dimcs.stats().get("clear") == 0) : "Cache store should not be cleared, purgeOnStartup is false";
            assert ((Integer)dimcs.stats().get("write") == 4) : "Cache store should have been written to 4 times, but was written to " + dimcs.stats().get("write") + " times";
        }
        this.executeSimpleQuery((Cache<String, Person>)((Cache)this.caches().get(0)));
        this.addNodeCheckingContentsAndQuery();
    }
}

