/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.IncompleteCondition;
import org.infinispan.query.dsl.impl.NotCondition;
import org.infinispan.query.dsl.impl.SortCriteria;
import org.infinispan.query.dsl.impl.Visitable;
import org.infinispan.query.dsl.impl.Visitor;

public abstract class BaseQueryBuilder<T extends Query>
implements QueryBuilder<T>,
Visitable {
    protected final String rootTypeName;
    protected String[] projection;
    protected BaseCondition filterCondition;
    protected List<SortCriteria> sortCriteria;
    protected long startOffset = -1L;
    protected int maxResults = -1;

    protected BaseQueryBuilder(String rootTypeName) {
        if (rootTypeName == null) {
            throw new IllegalArgumentException("rootTypeName cannot be null");
        }
        this.rootTypeName = rootTypeName;
    }

    protected String getRootTypeName() {
        return this.rootTypeName;
    }

    @Override
    public QueryBuilder<T> orderBy(String attributePath, SortOrder sortOrder) {
        if (this.sortCriteria == null) {
            this.sortCriteria = new ArrayList<SortCriteria>();
        }
        this.sortCriteria.add(new SortCriteria(attributePath, sortOrder));
        return this;
    }

    protected List<SortCriteria> getSortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public QueryBuilder<T> setProjection(String ... projection) {
        this.projection = projection;
        return this;
    }

    protected String[] getProjection() {
        return this.projection;
    }

    @Override
    public QueryBuilder<T> startOffset(long startOffset) {
        if (startOffset < 0L) {
            throw new IllegalArgumentException("startOffset cannot be less than 0");
        }
        this.startOffset = startOffset;
        return this;
    }

    @Override
    public QueryBuilder<T> maxResults(int maxResults) {
        if (maxResults <= 0) {
            throw new IllegalArgumentException("maxResults must be greater than 0");
        }
        this.maxResults = maxResults;
        return this;
    }

    protected BaseCondition getFilterCondition() {
        return this.filterCondition;
    }

    @Override
    public FilterConditionEndContext having(String attributePath) {
        if (this.filterCondition != null) {
            throw new IllegalStateException("Sentence already started. Cannot use 'having(..)' again.");
        }
        AttributeCondition attributeCondition = new AttributeCondition(attributePath);
        attributeCondition.setQueryBuilder(this);
        this.filterCondition = attributeCondition;
        return attributeCondition;
    }

    @Override
    public FilterConditionBeginContext not() {
        if (this.filterCondition != null) {
            throw new IllegalStateException("Sentence already started. Cannot use 'not()' again.");
        }
        IncompleteCondition incompleteCondition = new IncompleteCondition();
        incompleteCondition.setQueryBuilder(this);
        this.filterCondition = incompleteCondition;
        return incompleteCondition.not();
    }

    @Override
    public FilterConditionContext not(FilterConditionContext fcc) {
        if (this.filterCondition != null) {
            throw new IllegalStateException("Sentence already started. Cannot use 'not(..)' again.");
        }
        NotCondition notCondition = new NotCondition(((BaseCondition)fcc).getRoot());
        notCondition.setQueryBuilder(this);
        this.filterCondition = notCondition;
        return this.filterCondition;
    }

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        return visitor.visit(this);
    }
}

