/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.CacheManagerService;
import org.hibernate.search.spi.WorkerBuildContext;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.indexmanager.IndexUpdateCommand;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.LogFactory;

public class InfinispanCommandsBackend
implements BackendQueueProcessor {
    private static final Log log = (Log)LogFactory.getLog(InfinispanCommandsBackend.class, Log.class);
    private EmbeddedCacheManager cacheManager;
    private ServiceManager serviceManager;
    private String indexName;
    private DistributionManager distributionManager;
    private RpcManager rpcManager;
    private String cacheName;
    private DirectoryBasedIndexManager indexManager;

    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.indexManager = indexManager;
        this.serviceManager = context.getServiceManager();
        CacheManagerService cacheManagerService = (CacheManagerService)this.serviceManager.requestService(CacheManagerService.class);
        this.cacheManager = cacheManagerService.getEmbeddedCacheManager();
        ComponentRegistryService componentRegistryService = (ComponentRegistryService)this.serviceManager.requestService(ComponentRegistryService.class);
        ComponentRegistry componentsRegistry = componentRegistryService.getComponentRegistry();
        this.indexName = indexManager.getIndexName();
        this.rpcManager = (RpcManager)componentsRegistry.getComponent(RpcManager.class);
        this.cacheName = componentsRegistry.getCacheName();
        this.distributionManager = (DistributionManager)componentsRegistry.getComponent(DistributionManager.class);
        log.commandsBackendInitialized(this.indexName);
    }

    public void close() {
        this.serviceManager.releaseService(CacheManagerService.class);
        this.serviceManager.releaseService(ComponentRegistryService.class);
        this.serviceManager = null;
        this.cacheManager = null;
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        IndexUpdateCommand command = new IndexUpdateCommand(this.cacheName);
        byte[] serializedModel = this.indexManager.getSerializer().toSerializedModel(workList);
        command.setSerializedWorkList(serializedModel);
        command.setIndexName(this.indexName);
        this.sendCommand(command, workList);
    }

    private void sendCommand(ReplicableCommand command, List<LuceneWork> workList) {
        Address primaryNodeAddress = this.getPrimaryNodeAddress();
        Set<Address> recipients = Collections.singleton(primaryNodeAddress);
        this.rpcManager.invokeRemotely(recipients, command, this.rpcManager.getDefaultRpcOptions(true));
        log.workListRemotedTo(workList, primaryNodeAddress);
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.applyWork(Collections.singletonList(singleOperation), monitor);
    }

    public Lock getExclusiveWriteLock() {
        throw new UnsupportedOperationException("Not Implementable: nonsense on a distributed index.");
    }

    public void indexMappingChanged() {
    }

    public boolean isMasterLocal() {
        Transport transport = this.cacheManager.getTransport();
        if (transport == null) {
            return true;
        }
        Address primaryLocation = this.getPrimaryNodeAddress();
        Address localAddress = transport.getAddress();
        return localAddress.equals(primaryLocation);
    }

    private Address getPrimaryNodeAddress() {
        Transport transport = this.cacheManager.getTransport();
        if (transport == null) {
            return null;
        }
        if (this.distributionManager == null) {
            List members = transport.getMembers();
            int elementIndex = Math.abs(this.indexName.hashCode()) % members.size();
            return (Address)members.get(elementIndex);
        }
        return this.distributionManager.getPrimaryLocation((Object)this.indexName);
    }
}

