/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.queryparser.classic.ParseException;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(testName="query.config.DeclarativeConfigTest", groups={"functional"})
public class DeclarativeConfigTest
extends SingleCacheManagerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:7.0 http://www.infinispan.org/schemas/infinispan-config-7.0.xsd\"\n      xmlns=\"urn:infinispan:config:7.0\">\n<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <indexing index=\"LOCAL\">\n            <property name=\"default.directory_provider\">ram</property>\n      </indexing>\n   </local-cache>\n</cache-container></infinispan>";
        System.out.println("Using test configuration:\n\n" + config + "\n");
        try (ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());){
            this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        this.cache = this.cacheManager.getCache();
        return this.cacheManager;
    }

    public void simpleIndexTest() throws ParseException {
        this.cache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(this.cache, "name", "Name");
        Assert.assertEquals((long)1L, (long)cq.getResultSize());
        List l = cq.list();
        Assert.assertEquals((long)1L, (long)l.size());
        Person p = (Person)l.get(0);
        Assert.assertEquals((Object)"A Person's Name", (Object)p.getName());
        Assert.assertEquals((Object)"A paragraph containing some text", (Object)p.getBlurb());
        Assert.assertEquals((long)75L, (long)p.getAge());
    }

    @Test(dependsOnMethods={"simpleIndexTest"})
    public void testPropertiesWhereRead() {
        SearchFactoryIntegrator searchFactory = TestQueryHelperFactory.extractSearchFactory(this.cache);
        EntityIndexBinding indexBindingForEntity = searchFactory.getIndexBinding(Person.class);
        IndexManager[] managers = indexBindingForEntity.getIndexManagers();
        Assert.assertEquals((long)1L, (long)managers.length);
        Assert.assertNotNull((Object)managers[0]);
        Assert.assertTrue((boolean)(managers[0] instanceof DirectoryBasedIndexManager));
        DirectoryBasedIndexManager dbim = (DirectoryBasedIndexManager)managers[0];
        Assert.assertTrue((boolean)(dbim.getDirectoryProvider() instanceof RAMDirectoryProvider));
    }
}

