/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.junit.Assert;

public class StaticTestingErrorHandler
implements ErrorHandler {
    private final AtomicReference faulty = new AtomicReference();

    public void handle(ErrorContext context) {
        this.faulty.compareAndSet(null, new ThrowableWrapper(context.getOperationAtFault().toString(), context.getThrowable()));
    }

    public void handleException(String errorMsg, Throwable exception) {
        this.faulty.compareAndSet(null, new ThrowableWrapper(errorMsg, exception));
    }

    private Object getAndReset() {
        return this.faulty.getAndSet(null);
    }

    public static void assertAllGood(Cache cache) {
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)searchManager.getSearchFactory();
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        Assert.assertNotNull((Object)errorHandler);
        Assert.assertTrue((boolean)(errorHandler instanceof StaticTestingErrorHandler));
        StaticTestingErrorHandler instance = (StaticTestingErrorHandler)errorHandler;
        Object fault = instance.getAndReset();
        if (fault != null) {
            Assert.fail((String)fault.toString());
        }
    }

    public static void assertAllGood(Cache ... caches) {
        for (Cache cache : caches) {
            StaticTestingErrorHandler.assertAllGood(cache);
        }
    }

    public static class ThrowableWrapper {
        private final String errorMsg;
        private final Throwable exception;

        public ThrowableWrapper(String errorMsg, Throwable exception) {
            this.errorMsg = errorMsg;
            this.exception = exception;
        }

        public String toString() {
            StringWriter w = new StringWriter();
            w.append(String.valueOf(this.errorMsg));
            if (this.exception != null) {
                w.append(' ');
                this.exception.printStackTrace(new PrintWriter(w));
            }
            return w.toString();
        }
    }
}

