/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.ranges;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.queries.ranges.QueryRangesTest")
public class QueryRangesTest
extends SingleCacheManagerTest {
    private Person person1;
    private Person person2;
    private Person person3;
    private Person person4;
    protected String key1 = "test1";
    protected String key2 = "test2";
    protected String key3 = "test3";

    public QueryRangesTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testQueryingRangeBelowExcludingLimit() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").below((Object)30).excludeLimit().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeBelowWithLimit() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").below((Object)30).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 4) : "Size of list should be 4";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeAboveExcludingLimit() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").above((Object)30).excludeLimit().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").above((Object)20).excludeLimit().createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeAboveWithLimit() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").above((Object)30).excludeLimit().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").above((Object)20).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 4) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRange() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").from((Object)20).excludeLimit().to((Object)30).excludeLimit().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Mighty Goat also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 3";
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeWithLimits() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").from((Object)20).to((Object)30).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Mighty Goat also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 4) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        Person person5 = new Person();
        person5.setName("ANother Goat");
        person5.setBlurb("Some other goat should eat grass.");
        person5.setAge(31);
        this.cache.put((Object)"anotherGoat", (Object)person5);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 4) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeWithLimitsAndExclusions() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").from((Object)20).excludeLimit().to((Object)30).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Mighty Goat also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        Person person5 = new Person();
        person5.setName("ANother Goat");
        person5.setBlurb("Some other goat should eat grass.");
        person5.setAge(31);
        this.cache.put((Object)"anotherGoat", (Object)person5);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").from((Object)20).to((Object)30).excludeLimit().createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    public void testQueryingRangeForDatesWithLimitsAndExclusions() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("dateOfGraduation").from((Object)this.formatDate("May 5, 2002")).excludeLimit().to((Object)this.formatDate("June 30, 2012")).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        this.person4 = new Person("Mighty Goat", "Mighty Goat also eats grass", 28, this.formatDate("June 15, 2007"));
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        Person person5 = new Person("Another Goat", "Some other goat should eat grass.", 31, this.formatDate("July 5, 2012"));
        this.cache.put((Object)"anotherGoat", (Object)person5);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("dateOfGraduation").from((Object)this.formatDate("May 5, 2002")).to((Object)this.formatDate("June 10, 2012")).excludeLimit().createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    protected void loadTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(20);
        this.person1.setDateOfGraduation(this.formatDate("June 10, 2012"));
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(30);
        this.person2.setDateOfGraduation(this.formatDate("July 5, 2002"));
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(25);
        this.person3.setDateOfGraduation(this.formatDate("May 5, 2002"));
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
    }

    protected Date formatDate(String dateString) {
        Date date = null;
        try {
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(dateString);
        }
        catch (java.text.ParseException e) {
            throw new IllegalArgumentException("Unable to parse date.", e);
        }
        return date;
    }
}

