/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.transaction.TransactionManager;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.CacheManagerService;
import org.hibernate.search.spi.WorkerBuildContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.indexmanager.ClusteredSwitchingBackend;
import org.infinispan.query.indexmanager.IndexManagerBasedLockController;
import org.infinispan.query.indexmanager.LocalBackendFactory;
import org.infinispan.query.indexmanager.LocalOnlyBackend;
import org.infinispan.query.indexmanager.SimpleLocalBackendFactory;
import org.infinispan.query.indexmanager.SwitchingBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.logging.LogFactory;

final class InfinispanBackendQueueProcessor
implements BackendQueueProcessor {
    private static final Log log = (Log)LogFactory.getLog(InfinispanBackendQueueProcessor.class, Log.class);
    private ServiceManager serviceManager;
    private String indexName;
    private DirectoryBasedIndexManager indexManager;
    private SwitchingBackend fowardingBackend;

    InfinispanBackendQueueProcessor() {
    }

    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.indexManager = indexManager;
        SimpleLocalBackendFactory localBackendFactory = new SimpleLocalBackendFactory(indexManager, props, context);
        this.serviceManager = context.getServiceManager();
        CacheManagerService cacheManagerService = (CacheManagerService)this.serviceManager.requestService(CacheManagerService.class);
        this.indexName = indexManager.getIndexName();
        ComponentRegistryService componentRegistryService = (ComponentRegistryService)this.serviceManager.requestService(ComponentRegistryService.class);
        ComponentRegistry componentRegistry = componentRegistryService.getComponentRegistry();
        this.fowardingBackend = InfinispanBackendQueueProcessor.createForwardingBackend(componentRegistry, this.indexName, localBackendFactory, cacheManagerService, indexManager);
        log.commandsBackendInitialized(this.indexName);
    }

    private static SwitchingBackend createForwardingBackend(ComponentRegistry componentRegistry, String indexName, LocalBackendFactory localBackendFactory, CacheManagerService cacheManagerService, DirectoryBasedIndexManager indexManager) {
        RpcManager rpcManager = (RpcManager)componentRegistry.getComponent(RpcManager.class);
        if (rpcManager == null) {
            LocalOnlyBackend backend = new LocalOnlyBackend(localBackendFactory);
            backend.initialize();
            return backend;
        }
        EmbeddedCacheManager embeddedCacheManager = cacheManagerService.getEmbeddedCacheManager();
        TransactionManager transactionManager = (TransactionManager)componentRegistry.getComponent(TransactionManager.class);
        IndexManagerBasedLockController lockControl = new IndexManagerBasedLockController(indexManager, transactionManager);
        ClusteredSwitchingBackend backend = new ClusteredSwitchingBackend(componentRegistry, indexName, localBackendFactory, lockControl);
        backend.initialize();
        embeddedCacheManager.addListener((Object)backend);
        return backend;
    }

    public void close() {
        this.fowardingBackend.shutdown();
        this.serviceManager.releaseService(CacheManagerService.class);
        this.serviceManager.releaseService(ComponentRegistryService.class);
        this.serviceManager = null;
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        this.fowardingBackend.getCurrentIndexingBackend().applyWork(workList, monitor, this.indexManager);
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.fowardingBackend.getCurrentIndexingBackend().applyStreamWork(singleOperation, monitor, this.indexManager);
    }

    public Lock getExclusiveWriteLock() {
        throw new UnsupportedOperationException("Not Implementable: nonsense on a distributed index.");
    }

    public void indexMappingChanged() {
    }

    boolean isMasterLocal() {
        return this.fowardingBackend.getCurrentIndexingBackend().isMasterLocal();
    }
}

