/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.infinispan.query.indexmanager.IndexingBackend;
import org.infinispan.query.indexmanager.LazyInitializableBackend;

public class LazyInitializingBackend
implements IndexingBackend {
    private final LazyInitializableBackend backend;

    public LazyInitializingBackend(LazyInitializableBackend backend) {
        this.backend = backend;
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor, DirectoryBasedIndexManager indexManager) {
        this.backend.lazyInitialize();
        this.backend.getCurrentIndexingBackend().applyWork(workList, monitor, indexManager);
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor, DirectoryBasedIndexManager indexManager) {
        this.backend.lazyInitialize();
        this.backend.getCurrentIndexingBackend().applyStreamWork(singleOperation, monitor, indexManager);
    }

    @Override
    public boolean isMasterLocal() {
        return false;
    }

    @Override
    public void flushAndClose(IndexingBackend replacement) {
    }

    public String toString() {
        return "LazyInitializingBackend";
    }
}

