/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.query.dsl.impl.BaseQueryBuilder;
import org.infinispan.query.dsl.impl.JPAQueryGenerator;
import org.infinispan.query.dsl.impl.Visitor;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.KeyValuePair;
import org.junit.Assert;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.QueryCacheEmbeddedTest")
public class QueryCacheEmbeddedTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testQueryCache() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("John");
        this.cache.put((Object)("user_" + user.getId()), (Object)user);
        QueryCache queryCache = (QueryCache)TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, QueryCache.class);
        QueryCache queryCacheSpy = (QueryCache)Mockito.spy((Object)queryCache);
        TestingUtil.replaceComponent((CacheContainer)this.cacheManager, QueryCache.class, (Object)queryCacheSpy, (boolean)true);
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache);
        QueryBuilder queryQueryBuilder = qf.from(UserHS.class).having("name").eq((Object)"John").toBuilder();
        String jpaQuery = (String)((BaseQueryBuilder)queryQueryBuilder).accept((Visitor)new JPAQueryGenerator());
        AtomicReference<Object> lastGetResult = this.captureLastGetResult(queryCacheSpy);
        KeyValuePair queryCacheKey = new KeyValuePair((Object)jpaQuery, LuceneQueryParsingResult.class);
        LuceneQueryParsingResult cachedParsingResult = (LuceneQueryParsingResult)queryCache.get(queryCacheKey);
        Assert.assertNull((Object)cachedParsingResult);
        queryQueryBuilder.build();
        cachedParsingResult = (LuceneQueryParsingResult)queryCache.get(queryCacheKey);
        Assert.assertNotNull((Object)cachedParsingResult);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{queryCacheSpy});
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.calls((int)1))).get(queryCacheKey);
        ArgumentCaptor captor = ArgumentCaptor.forClass(LuceneQueryParsingResult.class);
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.calls((int)1))).put((KeyValuePair)Matchers.eq((Object)queryCacheKey), captor.capture());
        inOrder.verifyNoMoreInteractions();
        Assert.assertNull((Object)lastGetResult.get());
        Assert.assertTrue((captor.getValue() == cachedParsingResult ? 1 : 0) != 0);
        Mockito.reset((Object[])new QueryCache[]{queryCacheSpy});
        lastGetResult = this.captureLastGetResult(queryCacheSpy);
        queryQueryBuilder.build();
        inOrder = Mockito.inOrder((Object[])new Object[]{queryCacheSpy});
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.calls((int)1))).get(queryCacheKey);
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.never())).put((KeyValuePair)Matchers.any(KeyValuePair.class), Matchers.any(LuceneQueryParsingResult.class));
        inOrder.verifyNoMoreInteractions();
        Assert.assertTrue((lastGetResult.get() == cachedParsingResult ? 1 : 0) != 0);
    }

    private AtomicReference<Object> captureLastGetResult(QueryCache queryCacheSpy) {
        final AtomicReference<Object> lastResult = new AtomicReference<Object>();
        ((QueryCache)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object result = invocation.callRealMethod();
                lastResult.set(result);
                return result;
            }
        }).when((Object)queryCacheSpy)).get((KeyValuePair)Matchers.any(KeyValuePair.class));
        return lastResult;
    }
}

