/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.jmx;

import java.io.InputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.jmx.DistributedMassIndexingViaJmxTest")
public class DistributedMassIndexingViaJmxTest
extends DistributedMassIndexingTest {
    static final String BASE_JMX_DOMAIN = DistributedMassIndexingViaJmxTest.class.getSimpleName();
    MBeanServer server;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        for (int i = 0; i < 4; ++i) {
            InputStream is = new FileLookup().lookupFileStrict("dynamic-indexing-distribution.xml", Thread.currentThread().getContextClassLoader());
            ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
            ConfigurationBuilderHolder holder = parserRegistry.parse(is);
            holder.getGlobalConfigurationBuilder().globalJmxStatistics().jmxDomain(BASE_JMX_DOMAIN + i).mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup());
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilderHolder)holder, (boolean)true);
            this.registerCacheManager(new CacheContainer[]{cm});
            Cache cache = cm.getCache();
            this.caches.add(cache);
        }
        this.waitForClusterToForm(neededCacheNames);
    }

    @Override
    protected void rebuildIndexes() throws Exception {
        String cacheManagerName = this.manager(0).getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
        ObjectName massIndexerObjName = this.getMassIndexerObjectName(BASE_JMX_DOMAIN + 0, cacheManagerName, "___defaultcache");
        this.server.invoke(massIndexerObjName, "start", new Object[0], new String[0]);
    }

    private ObjectName getMassIndexerObjectName(String jmxDomain, String cacheManagerName, String cacheName) {
        try {
            return new ObjectName(jmxDomain + ":type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName) + ",component=MassIndexer");
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Malformed object name", (Throwable)e);
        }
    }
}

