/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.util.AnalyzerUtils;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.analysis.Team;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.analysis.SolrAnalyzerTest")
public class SolrAnalyzerTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testAnalyzerDef() throws Exception {
        Team team = new Team();
        team.setDescription("This is a D\u00e0scription");
        team.setLocation("Atlanta");
        team.setName("ATL team");
        this.cache.put((Object)"id", (Object)team);
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        TermQuery query = new TermQuery(new Term("description", "D\u00e0scription"));
        Assert.assertEquals((String)"iso latin filter should work.  \ufffd should be a now", (long)0L, (long)searchManager.getQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "is"));
        Assert.assertEquals((String)"stop word filter should work. is should be removed", (long)0L, (long)searchManager.getQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "dascript"));
        Assert.assertEquals((String)"snowball stemmer should work. 'dascription' should be stemmed to 'dascript'", (long)1L, (long)searchManager.getQuery((Query)query, new Class[0]).list().size());
    }

    public void testAnalyzers() throws Exception {
        SearchManager search = Search.getSearchManager((Cache)this.cache);
        Analyzer analyzer = search.getAnalyzer("standard_analyzer");
        String text = "This is just FOOBAR's";
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "just", "FOOBAR's"});
        analyzer = search.getAnalyzer("html_standard_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "foobar's"});
        analyzer = search.getAnalyzer("html_whitespace_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "foobar's"});
        analyzer = search.getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"abc", "abcd", "abcde"});
        analyzer = search.getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"abc", "abcd", "abcde"});
        analyzer = search.getAnalyzer("porter_analyzer");
        text = "bikes bikes biking";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"bike", "bike", "bike"});
        analyzer = search.getAnalyzer("word_analyzer");
        text = "CamelCase";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"Camel", "Case"});
        analyzer = search.getAnalyzer("synonym_analyzer");
        text = "ipod cosmos";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"ipod", "i-pod", "universe", "cosmos"});
        analyzer = search.getAnalyzer("shingle_analyzer");
        text = "please divide this sentence into shingles";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"please", "please divide", "divide", "divide this", "this", "this sentence", "sentence", "sentence into", "into", "into shingles", "shingles"});
        analyzer = search.getAnalyzer("pattern_analyzer");
        text = "foo,bar";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"foo", "bar"});
        analyzer = search.getAnalyzer("mapping_char_analyzer");
        text = "CORA\u00c7\u00c3O DE MEL\u00c3O";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        SolrAnalyzerTest.assertTokensEqual(tokens, new String[]{"CORACAO", "DE", "MELAO"});
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Team.class};
    }

    private static void assertTokensEqual(Token[] tokens, String[] strings) {
        Assert.assertEquals((long)strings.length, (long)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            Assert.assertEquals((String)("index " + i), (Object)strings[i], (Object)AnalyzerUtils.getTermText((Token)tokens[i]));
        }
    }
}

