/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.IOException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.QueryInterceptorIndexingOperationsTest")
public class QueryInterceptorIndexingOperationsTest
extends SingleCacheManagerTest {
    public QueryInterceptorIndexingOperationsTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Test
    public void testAvoidUnnecessaryRemoveForSimpleUpdate() throws IOException {
        Directory directory = this.initializeAndExtractDirectory(this.cache);
        Entity1 entity1 = new Entity1("e1");
        this.cache.put((Object)1, (Object)entity1);
        long commits = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory, new Operation(){

            @Override
            public void execute() {
                QueryInterceptorIndexingOperationsTest.this.cache.put((Object)1, (Object)new Entity1("e2"));
            }
        });
        AssertJUnit.assertEquals((long)1L, (long)commits);
        AssertJUnit.assertEquals((int)1, (int)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((int)0, (int)this.countIndexedDocuments(Entity2.class));
    }

    @Test
    public void testOverrideNonIndexedByIndexed() throws IOException {
        Directory directory = this.initializeAndExtractDirectory(this.cache);
        this.cache.put((Object)1, (Object)"string value");
        long commits = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory, new Operation(){

            @Override
            public void execute() {
                QueryInterceptorIndexingOperationsTest.this.cache.put((Object)1, (Object)new Entity1("e1"));
            }
        });
        AssertJUnit.assertEquals((long)1L, (long)commits);
        AssertJUnit.assertEquals((int)1, (int)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((int)0, (int)this.countIndexedDocuments(Entity2.class));
    }

    @Test
    public void testOverrideIndexedByNonIndexed() throws IOException {
        Directory directory = this.initializeAndExtractDirectory(this.cache);
        Entity1 entity1 = new Entity1("title");
        this.cache.put((Object)1, (Object)entity1);
        long commits = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory, new Operation(){

            @Override
            public void execute() {
                QueryInterceptorIndexingOperationsTest.this.cache.put((Object)1, (Object)"another");
            }
        });
        AssertJUnit.assertEquals((long)1L, (long)commits);
        AssertJUnit.assertEquals((int)0, (int)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((int)0, (int)this.countIndexedDocuments(Entity2.class));
    }

    @Test
    public void testOverrideIndexedByOtherIndexed() throws IOException {
        Directory directory = this.initializeAndExtractDirectory(this.cache);
        Entity1 entity1 = new Entity1("title");
        this.cache.put((Object)1, (Object)entity1);
        long commits = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory, new Operation(){

            @Override
            public void execute() {
                QueryInterceptorIndexingOperationsTest.this.cache.put((Object)1, (Object)new Entity2("title2"));
            }
        });
        AssertJUnit.assertEquals((long)2L, (long)commits);
        AssertJUnit.assertEquals((int)0, (int)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((int)1, (int)this.countIndexedDocuments(Entity2.class));
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.indexing().index(Index.ALL).addProperty("default.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager");
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        Configuration nonIndexed = this.nonIndexed();
        cm.defineConfiguration("LuceneIndexesMetadata", nonIndexed);
        cm.defineConfiguration("LuceneIndexesData", nonIndexed);
        cm.defineConfiguration("LuceneIndexesLocking", nonIndexed);
        return cm;
    }

    private Configuration nonIndexed() {
        return new ConfigurationBuilder().indexing().index(Index.NONE).build();
    }

    static long doRecordingCommits(Directory directory, Operation operation) throws IOException {
        long initialGen = SegmentInfos.getLastCommitGeneration((Directory)directory);
        operation.execute();
        return SegmentInfos.getLastCommitGeneration((Directory)directory) - initialGen;
    }

    private Directory initializeAndExtractDirectory(Cache cache) {
        QueryInterceptor queryInterceptor = (QueryInterceptor)TestingUtil.extractComponent((Cache)cache, QueryInterceptor.class);
        SearchFactoryIntegrator searchFactory = queryInterceptor.getSearchFactory();
        searchFactory.addClasses(new Class[]{Entity1.class, Entity2.class});
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)searchFactory.getIndexBinding(Entity1.class).getIndexManagers()[0];
        return indexManager.getDirectoryProvider().getDirectory();
    }

    private int countIndexedDocuments(Class<?> clazz) {
        CacheQuery query = Search.getSearchManager((Cache)this.cache).getQuery((Query)new MatchAllDocsQuery(), new Class[]{clazz});
        return query.list().size();
    }

    @Indexed(index="theIndex")
    class Entity2 {
        @Field
        private final String attribute;

        public Entity2(String attribute) {
            this.attribute = attribute;
        }
    }

    @Indexed(index="theIndex")
    class Entity1 {
        @Field
        private final String attribute;

        public Entity1(String attribute) {
            this.attribute = attribute;
        }
    }

    static interface Operation {
        public void execute();
    }
}

