/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.massindex.DefaultMassIndexerProgressMonitor;
import org.infinispan.query.impl.massindex.IndexingMapper;
import org.infinispan.query.impl.massindex.IndexingReducer;

public class MapReduceMassIndexer
implements MassIndexer {
    private final AdvancedCache<Object, Object> cache;
    private final SearchIntegrator searchFactory;

    public MapReduceMassIndexer(AdvancedCache cache, SearchIntegrator searchFactory) {
        this.cache = cache;
        this.searchFactory = searchFactory;
    }

    @Override
    public void start() {
        this.wipeExistingIndexes();
        new MapReduceTask(this.cache).mappedWith((Mapper)new IndexingMapper()).reducedWith((Reducer)new IndexingReducer()).execute();
        this.flush();
    }

    private void wipeExistingIndexes() {
        QueryInterceptor queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(this.cache);
        queryInterceptor.purgeAllIndexes();
    }

    private void flush() {
        DefaultMassIndexerProgressMonitor progressMonitor = new DefaultMassIndexerProgressMonitor(this.cache.getAdvancedCache().getComponentRegistry().getTimeService());
        new DefaultBatchBackend(this.searchFactory, (MassIndexerProgressMonitor)progressMonitor).flush(this.searchFactory.getIndexedTypes());
    }
}

