/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedExecutorMassIndexer
implements MassIndexer {
    private static final Log LOG = (Log)LogFactory.getLog(DistributedExecutorMassIndexer.class, Log.class);
    private final AdvancedCache cache;
    private final SearchIntegrator searchIntegrator;
    private final IndexUpdater indexUpdater;

    public DistributedExecutorMassIndexer(AdvancedCache cache, SearchIntegrator searchIntegrator) {
        this.cache = cache;
        this.searchIntegrator = searchIntegrator;
        this.indexUpdater = new IndexUpdater((Cache<?, ?>)cache);
    }

    @Override
    public void start() {
        DefaultExecutorService executor = new DefaultExecutorService((Cache)this.cache);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        LinkedList<Class> toFlush = new LinkedList<Class>();
        boolean replicated = this.cache.getAdvancedCache().getCacheConfiguration().clustering().cacheMode().isReplicated();
        for (Class indexedType : this.searchIntegrator.getIndexedTypes()) {
            IndexManager[] indexManagers;
            EntityIndexBinding indexBinding = this.searchIntegrator.getIndexBinding(indexedType);
            for (IndexManager indexManager : indexManagers = indexBinding.getIndexManagers()) {
                IndexWorker indexWork;
                String indexName = indexManager.getIndexName();
                boolean shared = this.isShared(indexManager);
                if (shared) {
                    this.indexUpdater.purge(indexedType);
                    indexWork = new IndexWorker(indexedType, indexName, false);
                    toFlush.add(indexedType);
                } else {
                    indexWork = new IndexWorker(indexedType, indexName, true);
                }
                DistributedTaskBuilder builder = executor.createDistributedTaskBuilder((Callable)((Object)indexWork)).timeout(0L, TimeUnit.NANOSECONDS);
                DistributedTask task = builder.build();
                if (replicated && shared) {
                    futures.add((Future<Void>)executor.submit(task, new Object[0]));
                    continue;
                }
                futures.addAll(executor.submitEverywhere(task));
            }
        }
        this.waitForAll(futures);
        for (Class type : toFlush) {
            this.indexUpdater.flush(type);
        }
    }

    private void waitForAll(ArrayList<Future<Void>> futures) {
        for (Future<Void> f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.errorExecutingMassIndexer(e);
            }
        }
    }

    private boolean isShared(IndexManager indexManager) {
        return indexManager instanceof InfinispanIndexManager;
    }
}

