/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.Serializable;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.DefaultInstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.massindex.DefaultMassIndexerProgressMonitor;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IndexUpdater {
    private static final Log LOG = (Log)LogFactory.getLog(IndexUpdater.class, Log.class);
    private final SearchIntegrator searchIntegrator;
    private final KeyTransformationHandler keyTransformationHandler;
    private final DefaultBatchBackend defaultBatchBackend;
    private final QueryInterceptor queryInterceptor;

    public IndexUpdater(Cache<?, ?> cache) {
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        this.searchIntegrator = this.queryInterceptor.getSearchFactory();
        this.keyTransformationHandler = this.queryInterceptor.getKeyTransformationHandler();
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        DefaultMassIndexerProgressMonitor monitor = new DefaultMassIndexerProgressMonitor(componentRegistry.getTimeService());
        this.defaultBatchBackend = new DefaultBatchBackend(this.searchIntegrator, (MassIndexerProgressMonitor)monitor);
    }

    public void flush(Class<?> entityType) {
        LOG.flushingIndex(entityType.getName());
        this.defaultBatchBackend.flush(Util.asSet((Object[])new Class[]{entityType}));
    }

    public void purge(Class<?> entityType) {
        LOG.purgingIndex(entityType.getName());
        this.queryInterceptor.purgeIndex(entityType);
    }

    public void updateIndex(Object key, Object value, String indexName) {
        if (value != null) {
            Class<?> clazz = value.getClass();
            EntityIndexBinding entityIndexBinding = this.searchIntegrator.getIndexBinding(clazz);
            if (entityIndexBinding == null) {
                return;
            }
            ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
            DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
            String idInString = this.keyTransformationHandler.keyToString(key);
            UpdateLuceneWork updateTask = docBuilder.createUpdateWork(clazz, value, (Serializable)((Object)idInString), idInString, DefaultInstanceInitializer.DEFAULT_INITIALIZER, (ConversionContext)conversionContext);
            try {
                IndexManager indexManagerForAddition = entityIndexBinding.getSelectionStrategy().getIndexManagerForAddition(clazz, (Serializable)((Object)idInString), idInString, updateTask.getDocument());
                if (indexManagerForAddition.getIndexName().equals(indexName)) {
                    this.defaultBatchBackend.enqueueAsyncWork((LuceneWork)updateTask);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

