/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.massindex.IndexUpdater;

public class IndexWorker
implements DistributedCallable<Void, Void, Void> {
    protected Cache<?, ?> cache;
    protected final Class<?> entity;
    protected final String indexName;
    private final boolean flush;
    protected IndexUpdater indexUpdater;
    private ClusteringDependentLogic clusteringDependentLogic;
    private EntryRetriever entryRetriever;

    public IndexWorker(Class<?> entity, String indexName, boolean flush) {
        this.entity = entity;
        this.indexName = indexName;
        this.flush = flush;
    }

    public void setEnvironment(Cache<Void, Void> cache, Set<Void> inputKeys) {
        this.cache = cache;
        this.indexUpdater = new IndexUpdater(cache);
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        this.entryRetriever = (EntryRetriever)componentRegistry.getComponent(EntryRetriever.class);
        this.clusteringDependentLogic = (ClusteringDependentLogic)componentRegistry.getComponent(ClusteringDependentLogic.class);
    }

    protected void preIndex() {
        if (this.flush) {
            this.indexUpdater.purge(this.entity);
        }
    }

    protected void postIndex() {
        if (this.flush) {
            this.indexUpdater.flush(this.entity);
        }
    }

    private KeyValueFilter getFilter() {
        boolean replicated = this.cache.getCacheConfiguration().clustering().cacheMode().isReplicated();
        return replicated ? AcceptAllKeyValueFilter.getInstance() : new PrimaryOwnersKeyValueFilter();
    }

    private Object extractValue(Object wrappedValue) {
        if (wrappedValue instanceof MarshalledValue) {
            return ((MarshalledValue)wrappedValue).get();
        }
        return wrappedValue;
    }

    public Void call() throws Exception {
        this.preIndex();
        KeyValueFilter filter = this.getFilter();
        try (CloseableIterator iterator = this.entryRetriever.retrieveEntries(filter, null, Util.asSet((Object[])new Flag[]{Flag.CACHE_MODE_LOCAL}), null);){
            while (iterator.hasNext()) {
                CacheEntry next = (CacheEntry)iterator.next();
                Object value = this.extractValue(next.getValue());
                if (value == null || !value.getClass().equals(this.entity)) continue;
                this.indexUpdater.updateIndex(next.getKey(), value, this.indexName);
            }
        }
        this.postIndex();
        return null;
    }

    public static class Externalizer
    extends AbstractExternalizer<IndexWorker> {
        public Set<Class<? extends IndexWorker>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{IndexWorker.class});
        }

        public void writeObject(ObjectOutput output, IndexWorker worker) throws IOException {
            output.writeObject(worker.entity);
            output.writeUTF(worker.indexName);
            output.writeBoolean(worker.flush);
        }

        public IndexWorker readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new IndexWorker((Class)input.readObject(), input.readUTF(), input.readBoolean());
        }

        public Integer getId() {
            return ExternalizerIds.INDEX_WORKER;
        }
    }

    private class PrimaryOwnersKeyValueFilter
    implements KeyValueFilter {
        private PrimaryOwnersKeyValueFilter() {
        }

        public boolean accept(Object key, Object value, Metadata metadata) {
            return IndexWorker.this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
        }
    }
}

