/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.dsl.embedded.impl.FilterAndConverter;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.FilterAndConverterLocalTest")
public class FilterAndConverterLocalTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test
    public void testFilter() {
        for (int i = 0; i < 10; ++i) {
            Cache cache = this.cache();
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 30);
            cache.put((Object)i, (Object)value);
        }
        EntryRetriever retriever = (EntryRetriever)this.cache().getAdvancedCache().getComponentRegistry().getComponent(EntryRetriever.class);
        FilterAndConverter filterAndConverter = new FilterAndConverter("from org.infinispan.query.test.Person where blurb is null and age <= 31", ReflectionMatcher.class);
        CloseableIterator iterator = retriever.retrieveEntries((KeyValueFilter)filterAndConverter, (Converter)filterAndConverter, null, null);
        Map results = this.mapFromIterator((Iterator)iterator);
        Assert.assertEquals((long)2L, (long)results.size());
        for (ObjectFilter.FilterResult p : results.values()) {
            Assert.assertNull((Object)((Person)p.getInstance()).getBlurb());
            Assert.assertTrue((((Person)p.getInstance()).getAge() <= 31 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Map<K, ObjectFilter.FilterResult> mapFromIterator(Iterator<Map.Entry<K, ObjectFilter.FilterResult>> iterator) {
        try {
            HashMap<K, ObjectFilter.FilterResult> result = new HashMap<K, ObjectFilter.FilterResult>();
            while (iterator.hasNext()) {
                Map.Entry<K, ObjectFilter.FilterResult> entry = iterator.next();
                result.put(entry.getKey(), entry.getValue());
            }
            HashMap<K, ObjectFilter.FilterResult> hashMap = result;
            return hashMap;
        }
        finally {
            if (iterator instanceof Closeable) {
                try {
                    ((Closeable)((Object)iterator)).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

