/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.spi.SearchManagerImplementor;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.blackbox.LocalCacheTest")
public class LocalCacheTest
extends SingleCacheManagerTest {
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected Person person4;
    protected AnotherGrassEater anotherGrassEater;
    protected QueryParser queryParser;
    protected String key1 = "Navin";
    protected String key2 = "BigGoat";
    protected String key3 = "MiniGoat";
    protected String anotherGrassEaterKey = "anotherGrassEaterKey";

    public LocalCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testSimple() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        List found = cacheQuery.list();
        int elems = found.size();
        assert (elems == 1) : "Expected 1 but was " + elems;
        Object val = found.get(0);
        assert (val.equals(this.person1)) : "Expected " + this.person1 + " but was " + val;
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testSimpleForNonField() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "nonSearchableField", "test1");
        List found = cacheQuery.list();
        int elems = found.size();
        assert (elems == 0) : "Expected 0 but was " + elems;
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEagerIterator() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testEagerIteratorRemove() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (found.hasNext());
            found.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEagerIteratorExCase() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
            found.next();
        }
    }

    public void testMultipleResults() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        Assert.assertTrue((boolean)found.contains(this.person2));
        Assert.assertTrue((boolean)found.contains(this.person3));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testModified() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        luceneQuery = this.queryParser.parse("pizza");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testAdded() throws ParseException {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        this.loadTestingData();
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class, AnotherGrassEater.class);
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache.put((Object)"mighty", (Object)this.person4);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testRemoved() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.contains(this.person2));
        assert (found.contains(this.person3)) : "This should still contain object person3";
        this.cache.remove((Object)this.key3);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.contains(this.person2));
        assert (!found.contains(this.person3)) : "The search should not return person3";
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testUpdated() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2)) : "The search should have person2";
        this.cache.put((Object)this.key2, (Object)this.person1);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1) : "Size of list should be 1";
        assert (!found.contains(this.person2)) : "Person 2 should not be found now";
        assert (!found.contains(this.person1)) : "Person 1 should not be found because it does not meet the search criteria";
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testSetSort() throws ParseException {
        this.loadTestingData();
        Sort sort = new Sort(new SortField("age", SortField.Type.STRING));
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.get(0).equals(this.person3));
        assert (found.get(1).equals(this.person2));
        StaticTestingErrorHandler.assertAllGood(this.cache);
        this.person2.setAge(10);
        this.cache.put((Object)this.key2, (Object)this.person2);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.get(0).equals(this.person2));
        assert (found.get(1).equals(this.person3));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testSetFilter() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        PrefixFilter filter = new PrefixFilter(new Term("blurb", "cheese"));
        cacheQuery.filter((Filter)filter);
        found = cacheQuery.list();
        assert (found.size() == 1);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyIterator() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Unknown FetchMode null")
    public void testUnknownFetchModeIterator() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions(){

            public FetchOptions fetchMode(FetchOptions.FetchMode fetchMode) {
                return null;
            }
        });){
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorWithDefaultOptions() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        try (ResultIterator found = cacheQuery.iterator();){
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testExplain() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        int matchCounter = 0;
        int i = 0;
        try {
            do {
                Explanation found;
                if (!(found = cacheQuery.explain(i)).isMatch()) continue;
                ++matchCounter;
            } while (++i < 10 && matchCounter != 3);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)matchCounter);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testFullTextFilterOnOff() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery query = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"cheese");
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        List result = query.list();
        Person person = (Person)result.get(0);
        Assert.assertEquals((Object)"Mini Goat", (Object)person.getName());
        Assert.assertEquals((Object)"Eats cheese", (Object)person.getBlurb());
        query.disableFullTextFilter("personFilter");
        Assert.assertEquals((long)3L, (long)query.getResultSize());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        try (ResultIterator iterator = cacheQuery.iterator();){
            if (iterator.hasNext()) {
                Object next = iterator.next();
                iterator.remove();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyIteratorWithOffset() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        try (ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            Assert.assertEquals((long)2L, (long)this.countElements(iterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchManagerWithNullCache() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("fish");
        CacheQuery cacheQuery = Search.getSearchManager(null).getQuery(luceneQuery, new Class[0]).firstResult(1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLazyIteratorWithInvalidFetchSize() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={NoSuchElementException.class})
    public void testLazyIteratorWithNoElementsFound() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("fish");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            found.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIteratorWithNullFetchMode() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).firstResult(1);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(null));){
            found.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchKeyTransformer() throws ParseException {
        SearchManagerImplementor manager = (SearchManagerImplementor)Search.getSearchManager((Cache)this.cache);
        manager.registerKeyTransformer(CustomKey3.class, CustomKey3Transformer.class);
        this.loadTestingDataWithCustomKey();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = manager.getQuery(luceneQuery, new Class[0]);
        try (ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            Assert.assertEquals((long)3L, (long)this.countElements(iterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchWithWrongCache() throws ParseException {
        Cache cache = (Cache)Mockito.mock(CacheImpl.class);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn(null);
        SearchManager manager = Search.getSearchManager((Cache)cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchManagerWithInstantiation() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        Search search = new Search();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.valueOf((String)"LAZY")));){
            assert (found.hasNext());
            found.next();
            assert (!found.hasNext());
        }
    }

    public void testGetResultSize() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 1);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxResults() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("eats");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]).maxResults(1);
        Assert.assertEquals((long)3L, (long)cacheQuery.getResultSize());
        Assert.assertEquals((long)1L, (long)cacheQuery.list().size());
        try (ResultIterator eagerIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            Assert.assertEquals((long)1L, (long)this.countElements(eagerIterator));
        }
        try (ResultIterator lazyIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            Assert.assertEquals((long)1L, (long)this.countElements(lazyIterator));
        }
        try (ResultIterator defaultIterator = cacheQuery.iterator();){
            Assert.assertEquals((long)1L, (long)this.countElements(defaultIterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private int countElements(ResultIterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public void testClear() {
        this.loadTestingData();
        Term navin = new Term("name", "navin");
        Term goat = new Term("name", "goat");
        BooleanQuery luceneQuery = new BooleanQuery();
        luceneQuery.add((Query)new TermQuery(goat), BooleanClause.Occur.SHOULD);
        luceneQuery.add((Query)new TermQuery(navin), BooleanClause.Occur.SHOULD);
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery((Query)luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 3) : "Expected 3, got " + cacheQuery.getResultSize();
        this.cache.clear();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery((Query)luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 0);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testTypeFiltering() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("grass");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.containsAll(Arrays.asList(this.person2, this.anotherGrassEater)));
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        luceneQuery = this.queryParser.parse("grass");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[]{AnotherGrassEater.class});
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.anotherGrassEater));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testEntityDiscovery() {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        Person p = new Person();
        p.setName("Lucene developer");
        p.setAge(30);
        p.setBlurb("works best on weekends");
        this.cache.put((Object)p.getName(), (Object)p);
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class);
    }

    private void assertIndexingKnows(Cache<Object, Object> cache, Class ... types) {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        SearchIntegrator searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        Assert.assertNotNull((Object)searchIntegrator);
        Map indexBindingForEntity = ((ExtendedSearchIntegrator)searchIntegrator.unwrap(ExtendedSearchIntegrator.class)).getIndexBindings();
        Assert.assertNotNull((Object)indexBindingForEntity);
        Set keySet = indexBindingForEntity.keySet();
        Assert.assertEquals((long)types.length, (long)keySet.size());
        Assert.assertTrue((boolean)keySet.containsAll(Arrays.asList(types)));
    }

    protected void loadTestingData() {
        this.prepareTestingData();
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void loadTestingDataWithCustomKey() {
        this.prepareTestingData();
        CustomKey3 customeKey1 = new CustomKey3(this.key1);
        CustomKey3 customeKey2 = new CustomKey3(this.key2);
        CustomKey3 customeKey3 = new CustomKey3(this.key3);
        this.cache.put((Object)customeKey1, (Object)this.person1);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void prepareTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setAge(20);
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setNonSearchableField("test1");
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setAge(30);
        this.person2.setBlurb("Eats grass");
        this.person2.setNonSearchableField("test2");
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setAge(25);
        this.person3.setBlurb("Eats cheese");
        this.person3.setNonSearchableField("test3");
        this.anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void enhanceConfig(ConfigurationBuilder c) {
    }
}

