/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.ClusteredQueryDslConditionsTest")
public class ClusteredQueryDslConditionsTest
extends QueryDslConditionsTest {
    protected static final String TEST_CACHE_NAME = "custom";
    protected Cache<Object, Object> cache1;
    protected Cache<Object, Object> cache2;

    protected Cache<Object, Object> getCacheForWrite() {
        return this.cache1;
    }

    protected Cache<Object, Object> getCacheForQuery() {
        return this.cache2;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfiguration = ClusteredQueryDslConditionsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        defaultConfiguration.clustering().stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(2, defaultConfiguration);
        ConfigurationBuilder cfg = this.initialCacheConfiguration();
        cfg.clustering().stateTransfer().fetchInMemoryState(true).indexing().index(Index.LOCAL).addProperty("default.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager");
        this.manager(0).defineConfiguration(TEST_CACHE_NAME, cfg.build());
        this.manager(1).defineConfiguration(TEST_CACHE_NAME, cfg.build());
        this.cache1 = this.manager(0).getCache(TEST_CACHE_NAME);
        this.cache2 = this.manager(1).getCache(TEST_CACHE_NAME);
    }

    protected ConfigurationBuilder initialCacheConfiguration() {
        return ClusteredQueryDslConditionsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
    }

    @Override
    public void testIndexPresence() {
        this.checkIndexPresence(this.cache1);
        this.checkIndexPresence(this.cache2);
    }

    private void checkIndexPresence(Cache cache) {
        SearchIntegrator searchFactory = Search.getSearchManager((Cache)cache).getSearchFactory();
        Assert.assertTrue((boolean)searchFactory.getIndexedTypes().contains(this.getModelFactory().getUserImplClass()));
        Assert.assertNotNull((Object)searchFactory.getIndexManager(this.getModelFactory().getUserImplClass().getName()));
        Assert.assertTrue((boolean)searchFactory.getIndexedTypes().contains(this.getModelFactory().getAccountImplClass()));
        Assert.assertNotNull((Object)searchFactory.getIndexManager(this.getModelFactory().getAccountImplClass().getName()));
        Assert.assertTrue((boolean)searchFactory.getIndexedTypes().contains(this.getModelFactory().getTransactionImplClass()));
        Assert.assertNotNull((Object)searchFactory.getIndexManager(this.getModelFactory().getTransactionImplClass().getName()));
        Assert.assertFalse((boolean)searchFactory.getIndexedTypes().contains(this.getModelFactory().getAddressImplClass()));
        Assert.assertNull((Object)searchFactory.getIndexManager(this.getModelFactory().getAddressImplClass().getName()));
    }
}

