/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Date;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.works.ByTermUpdateWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.Bond;
import org.infinispan.query.backend.Debenture;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultipleEntitiesTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test
    public void testIndexAndQuery() throws Exception {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        this.cache.put((Object)123405, (Object)new Bond(new Date(System.currentTimeMillis()), 450L));
        this.assertEfficientIndexingUsed(searchManager.getSearchFactory(), Bond.class);
        this.cache.put((Object)123502, (Object)new Debenture("GB", 116.0));
        this.assertEfficientIndexingUsed(searchManager.getSearchFactory(), Debenture.class);
        this.cache.put((Object)223456, (Object)new Bond(new Date(System.currentTimeMillis()), 550L));
        this.assertEfficientIndexingUsed(searchManager.getSearchFactory(), Bond.class);
        CacheQuery query = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Bond.class, Debenture.class});
        Assert.assertEquals((int)query.list().size(), (int)3);
        CacheQuery queryBond = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Bond.class});
        Assert.assertEquals((int)queryBond.getResultSize(), (int)2);
        CacheQuery queryDeb = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Debenture.class});
        Assert.assertEquals((int)queryDeb.getResultSize(), (int)1);
    }

    private void assertEfficientIndexingUsed(SearchIntegrator searchIntegrator, Class<?> clazz) {
        DirectoryBasedIndexManager im = (DirectoryBasedIndexManager)searchIntegrator.getIndexBinding(clazz).getIndexManagers()[0];
        LuceneBackendQueueProcessor bqp = (LuceneBackendQueueProcessor)im.getBackendQueueProcessor();
        LuceneBackendResources indexResources = bqp.getIndexResources();
        LuceneWorkVisitor visitor = indexResources.getVisitor();
        Assert.assertTrue((boolean)(TestingUtil.extractField((Object)visitor, (String)"updateDelegate") instanceof ByTermUpdateWorkDelegate));
    }
}

