/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import org.hibernate.hql.ParsingException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.NonIndexedQueryDslConditionsTest")
public class NonIndexedQueryDslConditionsTest
extends QueryDslConditionsTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        this.createClusteredCaches(1, cfg);
    }

    @Override
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Indexing was not enabled on this cache.*")
    public void testIndexPresence() {
        Search.getSearchManager((Cache)((Cache)this.getCacheForQuery())).getSearchFactory();
    }

    @Override
    public void testQueryFactoryType() {
        Assert.assertEquals(EmbeddedQueryFactory.class, this.getQueryFactory().getClass());
    }

    @Override
    @Test
    public void testEqNonIndexed() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Override
    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN000405:.*")
    public void testInvalidEmbeddedAttributeQuery() throws Exception {
        super.testInvalidEmbeddedAttributeQuery();
    }

    @Override
    @Test
    public void testNullOnIntegerField() throws Exception {
        super.testNullOnIntegerField();
    }

    public void testAnd5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").lt((Object)1000).and().having("age").lt((Object)1000).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }
}

