/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.backend.ExtendedSearchWorkCreator;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.backend.SearchWorkCreatorContext;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.DefaultSearchWorkCreator;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.ExtendedSearchWorkCreatorTest")
public class ExtendedSearchWorkCreatorTest
extends SingleCacheManagerTest {
    @Test
    public void testExtendedSearchCreatorForAdd() throws Exception {
        this.addCustomSearchWorkCreator();
        this.cache.put((Object)1, (Object)new Entity("value", "item-a", "item-b", "item-c"));
        AssertJUnit.assertEquals((int)4, (int)this.numberOfIndexedEntities(Entity.class));
    }

    @Test
    public void testExtendedSearchCreatorForDelete() throws Exception {
        this.addCustomSearchWorkCreator();
        this.cache.put((Object)1, (Object)new Entity("value", "item-a", "item-b", "item-c"));
        this.cache.remove((Object)1);
        AssertJUnit.assertEquals((int)0, (int)this.numberOfIndexedEntities(Entity.class));
    }

    @Test
    public void testExtendedSearchCreatorForUpdates() throws Exception {
        this.addCustomSearchWorkCreator();
        this.cache.put((Object)1, (Object)new Entity("value", "item-a", "item-b", "item-c"));
        AssertJUnit.assertEquals((int)4, (int)this.numberOfIndexedEntities(Entity.class));
        this.cache.put((Object)1, (Object)new Entity("value", "item-a"));
        AssertJUnit.assertEquals((int)2, (int)this.numberOfIndexedEntities(Entity.class));
    }

    private void addCustomSearchWorkCreator() {
        QueryInterceptor queryInterceptor = ComponentRegistryUtils.getQueryInterceptor((Cache)this.cache);
        queryInterceptor.setSearchWorkCreator((SearchWorkCreator)new ExtraValuesSearchWorkCreator());
    }

    private int numberOfIndexedEntities(Class<?> clazz) {
        return Search.getSearchManager((Cache)this.cache).getQuery((Query)new MatchAllDocsQuery(), new Class[]{clazz}).getResultSize();
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Indexed
    private static class Entity {
        @Field
        private String name;
        private Set<String> items = new HashSet<String>();

        public String getName() {
            return this.name;
        }

        public Set<String> getItems() {
            return this.items;
        }

        public Entity(String name, String ... values) {
            this.name = name;
            Collections.addAll(this.items, values);
        }
    }

    private static class ExtraValuesSearchWorkCreator
    extends DefaultSearchWorkCreator<Object>
    implements ExtendedSearchWorkCreator<Object> {
        private ExtraValuesSearchWorkCreator() {
        }

        public Collection<Work> createPerEntityWorks(Object value, Serializable id, WorkType workType) {
            LinkedList<Work> works = new LinkedList<Work>(super.createPerEntityWorks(value, id, workType));
            Entity e = (Entity)value;
            for (String item : e.getItems()) {
                Entity newEntity = new Entity(item, new String[0]);
                works.add(new Work((Object)newEntity, (Serializable)((Object)("item-" + item)), workType));
            }
            return works;
        }

        public boolean shouldRemove(SearchWorkCreatorContext context) {
            return true;
        }
    }
}

