/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(testName="query.blackbox.SearchFactoryShutdownTest", groups={"functional"})
public class SearchFactoryShutdownTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorrectShutdown() {
        EmbeddedCacheManager cc = null;
        try {
            ConfigurationBuilder cfg = new ConfigurationBuilder();
            cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
            cc = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
            Cache cache = cc.getCache();
            SearchIntegrator sfi = (SearchIntegrator)TestingUtil.extractComponent((Cache)cache, SearchIntegrator.class);
            assert (!sfi.isStopped());
            cc.stop();
            assert (sfi.isStopped());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
    }
}

