/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.distributed.Transaction;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.AsyncMassIndexTest")
public class AsyncMassIndexTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 2;
    protected List<Cache<Integer, Transaction>> caches = new ArrayList<Cache<Integer, Transaction>>(2);
    protected AbstractCacheTest.CleanupPhase cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = AsyncMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cacheCfg.indexing().index(Index.LOCAL).addProperty("default.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler");
        List cacheList = this.createClusteredCaches(2, cacheCfg);
        this.waitForClusterToForm("___defaultcache");
        for (Cache cache : cacheList) {
            this.caches.add((Cache<Integer, Transaction>)cache);
        }
    }

    private void populate(int elements) throws Exception {
        Cache<Integer, Transaction> cache = this.caches.get(0);
        for (int i = 0; i < elements; ++i) {
            cache.put((Object)i, (Object)new Transaction(i + 200, "bytes"));
        }
    }

    @Test
    public void testListener() throws Exception {
        Cache<Integer, Transaction> cache = this.caches.get(0);
        int elements = 50;
        this.populate(elements);
        SearchManager searchManager = Search.getSearchManager(cache);
        NotifyingFuture future = searchManager.getMassIndexer().startAsync();
        final CountDownLatch endLatch = new CountDownLatch(1);
        future.attachListener((FutureListener)new FutureListener<Void>(){

            public void futureDone(Future<Void> future) {
                endLatch.countDown();
            }
        });
        endLatch.await();
        this.checkIndex(elements, Transaction.class);
    }

    protected void checkIndex(int expectedNumber, Class<?> entity) {
        Cache<Integer, Transaction> c = this.caches.get(0);
        SearchManager searchManager = Search.getSearchManager(c);
        CacheQuery q = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{entity});
        int resultSize = q.getResultSize();
        AssertJUnit.assertEquals((int)expectedNumber, (int)resultSize);
    }
}

