/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.distributed.PerfTest", singleThreaded=true)
public class PerfTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 4;
    private static final int LOG_ON_EACH = 2000;
    private static final int NUMBER_OF_ITERATIONS = 50;
    private static final String[] neededCacheNames = new String[]{"___defaultcache", "LuceneIndexesMetadata", "LuceneIndexesData", "LuceneIndexesLocking"};

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 4; ++i) {
            EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml((String)"indexing-perf.xml");
            this.registerCacheManager(new CacheContainer[]{cacheManager});
        }
        this.waitForClusterToForm(neededCacheNames);
    }

    public void testIndexing() throws Exception {
        int carId = 0;
        int cacheId = 0;
        long start = System.nanoTime();
        for (int outherLoop = 0; outherLoop < 50; ++outherLoop) {
            Cache<String, Car> cache = this.getWriteOnlyCache(cacheId++ % 4);
            System.out.print("Using " + cacheId + ": " + cache + "\t");
            long blockStart = System.nanoTime();
            cache.startBatch();
            for (int innerLoop = 0; innerLoop < 2000; ++innerLoop) {
                cache.put((Object)("car" + ++carId), (Object)new Car("megane", "blue", 300 + carId));
                cache.put((Object)("car" + ++carId), (Object)new Car("bmw", "blue", 300 + carId));
            }
            cache.endBatch(true);
            System.out.println("Inserted 2000 cars in " + Util.prettyPrintTime((long)(System.nanoTime() - blockStart), (TimeUnit)TimeUnit.NANOSECONDS));
        }
        System.out.println("Test took " + Util.prettyPrintTime((long)(System.nanoTime() - start), (TimeUnit)TimeUnit.NANOSECONDS));
        this.verifyFindsCar(carId / 2, "megane");
    }

    private Cache<String, Car> getWriteOnlyCache(int cacheId) {
        Cache cache = this.cache(cacheId);
        AdvancedCache advancedCache = cache.getAdvancedCache();
        AdvancedCache withFlags = advancedCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_INDEX_CLEANUP});
        return withFlags;
    }

    private void verifyFindsCar(int expectedCount, String carMake) {
        for (int i = 0; i < 4; ++i) {
            this.verifyFindsCar(this.cache(i), expectedCount, carMake);
        }
    }

    private void verifyFindsCar(Cache cache, int expectedCount, String carMake) {
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        QueryBuilder carQueryBuilder = searchManager.buildQueryBuilderForClass(Car.class).get();
        Query fullTextQuery = carQueryBuilder.keyword().onField("make").matching((Object)carMake).createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(fullTextQuery, new Class[]{Car.class});
        Assert.assertEquals((long)expectedCount, (long)cacheQuery.getResultSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        PerfTest test = new PerfTest();
        test.createBeforeClass();
        try {
            test.testIndexing();
        }
        finally {
            test.destroy();
        }
    }
}

