/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.dsl.embedded.ClusteredListenerWithDslFilterProfilingTest")
public class ClusteredListenerWithDslFilterProfilingTest
extends MultipleCacheManagersTest {
    private final int NUM_NODES = 3;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = ClusteredListenerWithDslFilterProfilingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createClusteredCaches(3, cfgBuilder);
    }

    public void testEventFilterPerformance() {
        int i;
        long startTs = System.nanoTime();
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache(0));
        Query query = qf.from(Person.class).having("age").lte((Object)31).toBuilder().build();
        int numEntries = 100000;
        int numListeners = 1000;
        ArrayList<NoOpEntryListener> listeners = new ArrayList<NoOpEntryListener>(1000);
        for (i = 0; i < 1000; ++i) {
            NoOpEntryListener listener = new NoOpEntryListener();
            listeners.add(listener);
            this.cache(0).addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        }
        for (i = 0; i < 100000; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            Cache cache = this.cache(i % 3);
            MagicKey key = new MagicKey(cache);
            cache.put((Object)key, (Object)value);
        }
        for (NoOpEntryListener listener : listeners) {
            this.cache(0).removeListener((Object)listener);
        }
        long endTs = System.nanoTime();
        System.out.printf("ClusteredListenerWithDslFilterTest.testEventFilterPerformance took %d ms\n", (endTs - startTs) / 1000000L);
    }

    @Listener(clustered=true)
    public static class NoOpEntryListener {
        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent<?, ?> event) {
        }

        @CacheEntryModified
        public void handleEvent(CacheEntryModifiedEvent<?, ?> event) {
        }
    }
}

