/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.nulls;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.nulls.NullCollectionElementsTest")
public class NullCollectionElementsTest
extends SingleCacheManagerTest {
    private SearchManager searchManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.LOCAL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    protected void setup() throws Exception {
        super.setup();
        this.searchManager = Search.getSearchManager((Cache)this.cache);
    }

    @BeforeMethod
    public void insertData() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.put((Object)"1", (Object)new Foo("1"));
                return null;
            }
        });
    }

    @Test
    public void testQuerySkipsNullsInList() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.remove((Object)"1");
                Query query = NullCollectionElementsTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                List list = NullCollectionElementsTest.this.searchManager.getQuery(query, new Class[0]).list();
                assert (list.size() == 0);
                return null;
            }
        });
    }

    @Test
    public void testQuerySkipsNullsInEagerIterator() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.remove((Object)"1");
                Query query = NullCollectionElementsTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                ResultIterator iterator = NullCollectionElementsTest.this.searchManager.getQuery(query, new Class[0]).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
                Assert.assertFalse((boolean)iterator.hasNext());
                try {
                    iterator.next();
                    Assert.fail((String)"Expected NoSuchElementException");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Test
    public void testQuerySkipsNullsInDefaultIterator() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.remove((Object)"1");
                Query query = NullCollectionElementsTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                CacheQuery cacheQuery = NullCollectionElementsTest.this.searchManager.getQuery(query, new Class[0]);
                Assert.assertEquals((long)1L, (long)cacheQuery.getResultSize());
                ResultIterator iterator = cacheQuery.iterator();
                Assert.assertFalse((boolean)iterator.hasNext());
                try {
                    iterator.next();
                    Assert.fail((String)"Expected NoSuchElementException");
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Test
    public void testQuerySkipsNullsInLazyIterator() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.remove((Object)"1");
                Query query = NullCollectionElementsTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                ResultIterator iterator = NullCollectionElementsTest.this.searchManager.getQuery(query, new Class[0]).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
                Assert.assertFalse((boolean)iterator.hasNext());
                try {
                    iterator.next();
                    Assert.fail((String)"Expected NoSuchElementException");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Test
    public void testQueryReturnsNullWhenProjectingCacheValue() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.remove((Object)"1");
                Query query = NullCollectionElementsTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                ResultIterator iterator = NullCollectionElementsTest.this.searchManager.getQuery(query, new Class[0]).projection(new String[]{"__HSearch_This", "bar"}).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
                Assert.assertTrue((boolean)iterator.hasNext());
                Object[] projection = (Object[])iterator.next();
                Assert.assertNull((Object)projection[0]);
                Assert.assertEquals((Object)"1", (Object)projection[1]);
                return null;
            }
        });
    }

    private QueryBuilder createQueryBuilder() {
        return this.searchManager.buildQueryBuilderForClass(Foo.class).get();
    }

    @Indexed(index="FooIndex")
    public class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar", store=Store.YES)
        public String getBar() {
            return this.bar;
        }
    }
}

