/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.queryparser.classic.ParseException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.MultipleCachesTest")
public class MultipleCachesTest
extends SingleCacheManagerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm;
        String config = TestingUtil.InfinispanStartTag.LATEST + "\n" + "<cache-container default-cache=\"default\">" + "   <local-cache name=\"default\">\n" + "      <indexing index=\"NONE\" />\n" + "   </local-cache>\n" + "   <local-cache name=\"indexingenabled\">\n" + "      <indexing index=\"LOCAL\" >\n" + "            <property name=\"default.directory_provider\">ram</property>\n" + "            <property name=\"lucene_version\">LUCENE_CURRENT</property>\n" + "      </indexing>\n" + "   </local-cache>\n" + "</cache-container>" + "</infinispan>";
        this.log.tracef("Using test configuration:\n%s", (Object)config);
        try (ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());){
            cm = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        this.cache = cm.getCache();
        return cm;
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void queryNotIndexedCache() throws ParseException {
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedA");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(this.cache, "name", "Name");
        Assert.assertEquals((long)1L, (long)cq.getResultSize());
        List l = cq.list();
        Assert.assertEquals((long)1L, (long)l.size());
        Person p = (Person)l.get(0);
        Assert.assertEquals((Object)"A Person's Name", (Object)p.getName());
        Assert.assertEquals((Object)"A paragraph containing some text", (Object)p.getBlurb());
        Assert.assertEquals((long)75L, (long)p.getAge());
    }

    @Test
    public void notIndexedCacheNormalUse() {
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedB");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        assert (notIndexedCache.get((Object)"1") != null);
    }

    @Test
    public void indexedCache() throws ParseException {
        Cache indexedCache = this.cacheManager.getCache("indexingenabled");
        this.useQuery((Cache<Object, Object>)indexedCache);
    }

    private void useQuery(Cache<Object, Object> indexedCache) throws ParseException {
        indexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(indexedCache, "name", "Name");
        Assert.assertEquals((long)1L, (long)cq.getResultSize());
        List l = cq.list();
        Assert.assertEquals((long)1L, (long)l.size());
        Person p = (Person)l.get(0);
        Assert.assertEquals((Object)"A Person's Name", (Object)p.getName());
        Assert.assertEquals((Object)"A paragraph containing some text", (Object)p.getBlurb());
        Assert.assertEquals((long)75L, (long)p.getAge());
        SearchManager queryFactory = Search.getSearchManager(indexedCache);
        SearchIntegrator searchImpl = (SearchIntegrator)queryFactory.unwrap(SearchIntegrator.class);
        IndexManager[] indexManagers = searchImpl.getIndexBinding(Person.class).getIndexManagers();
        assert (indexManagers != null && indexManagers.length == 1);
        DirectoryBasedIndexManager directory = (DirectoryBasedIndexManager)indexManagers[0];
        DirectoryProvider directoryProvider = directory.getDirectoryProvider();
        assert (directoryProvider instanceof RAMDirectoryProvider) : "configuration properties where ignored";
    }
}

