/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.ListenerWithDslFilterTest")
public class ListenerWithDslFilterTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    public void testEventFilter() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)31).toBuilder().build();
        EntryListener listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)7L, (long)listener.results.size());
        for (ObjectFilter.FilterResult r : listener.results) {
            Person p = (Person)r.getInstance();
            Assert.assertTrue((p.getAge() <= 31 ? 1 : 0) != 0);
        }
        this.cache().removeListener((Object)listener);
        listener.results.clear();
        Person value = new Person();
        value.setName("George");
        value.setAge(30);
        this.cache().put((Object)-1, (Object)value);
        Assert.assertEquals((long)0L, (long)listener.results.size());
    }

    public void testEventFilterAndConverter() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)31).toBuilder().setProjection(new String[]{"name", "age"}).build();
        EntryListener listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache.put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)7L, (long)listener.results.size());
        for (ObjectFilter.FilterResult r : listener.results) {
            Assert.assertTrue(((Integer)r.getProjection()[1] <= 31 ? 1 : 0) != 0);
        }
        this.cache().removeListener((Object)listener);
    }

    @Listener
    public static class EntryListener {
        public final List<ObjectFilter.FilterResult> results = new ArrayList<ObjectFilter.FilterResult>();

        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent<?, ObjectFilter.FilterResult> event) {
            if (!event.isPre()) {
                ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
                this.results.add(filterResult);
            }
        }

        @CacheEntryModified
        public void handleEvent(CacheEntryModifiedEvent<?, ObjectFilter.FilterResult> event) {
            if (!event.isPre()) {
                ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
                this.results.add(filterResult);
            }
        }
    }
}

