/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.directoryinteraction;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.lucene.testutils.TestSegmentReadLocker;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucenedirectoryquery.IndexStoredIndexedCacheTest")
public class IndexStoredIndexedCacheTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configurationBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        configurationBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().fetchInMemoryState(true).l1().enable().sync().replTimeout(10000L).transaction().transactionMode(TransactionMode.TRANSACTIONAL).locking().lockAcquisitionTimeout(10000L).invocationBatching().disable().deadlockDetection().disable().jmxStatistics().disable().indexing().index(Index.ALL).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, "lucene", configurationBuilder);
    }

    @Test
    public void testIndexWritingAndFinding() throws IOException {
        String indexName = "indexName";
        Cache cache0 = this.cache(0, "lucene");
        Cache cache1 = this.cache(1, "lucene");
        TestSegmentReadLocker readLocker = new TestSegmentReadLocker(cache0, cache0, cache0, "indexName");
        Directory dirA = DirectoryBuilder.newDirectoryInstance((Cache)cache0, (Cache)cache0, (Cache)cache0, (String)"indexName").overrideSegmentReadLocker((SegmentReadLocker)readLocker).create();
        Directory dirB = DirectoryBuilder.newDirectoryInstance((Cache)cache1, (Cache)cache1, (Cache)cache1, (String)"indexName").overrideSegmentReadLocker((SegmentReadLocker)readLocker).create();
        CacheTestSupport.writeTextToIndex((Directory)dirA, (int)0, (String)"hi from node A");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, (String)"hi", (Integer[])new Integer[]{0});
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, (String)"hi", (Integer[])new Integer[]{0});
        CacheTestSupport.writeTextToIndex((Directory)dirB, (int)1, (String)"hello node A, how are you?");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, (String)"hello", (Integer[])new Integer[]{1});
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, (String)"hello", (Integer[])new Integer[]{1});
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, (String)"node", (Integer[])new Integer[]{1, 0});
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, (String)"node", (Integer[])new Integer[]{1, 0});
        CacheTestSupport.removeByTerm((Directory)dirA, (String)"from");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, (String)"node", (Integer[])new Integer[]{1});
        dirA.close();
        dirB.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure((Cache)cache0, (String)"indexName");
        DirectoryIntegrityCheck.verifyDirectoryStructure((Cache)cache1, (String)"indexName");
    }

    @Test(description="Verifies the caches can be reused after a Directory close")
    public void testCacheReuse() throws IOException {
        this.testIndexWritingAndFinding();
        this.cache(0, "lucene").clear();
        this.testIndexWritingAndFinding();
    }
}

