/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIteratorTest;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.impl.QueryResultLoader;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.LazyIteratorTest")
public class LazyIteratorTest
extends EagerIteratorTest {
    private DocumentExtractor extractor;

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.extractor = (DocumentExtractor)Mockito.mock(DocumentExtractor.class);
        Mockito.when((Object)this.extractor.getMaxIndex()).thenReturn((Object)(this.entityInfos.size() - 1));
        Mockito.when((Object)this.extractor.extract(Matchers.anyInt())).thenAnswer((Answer)new Answer<EntityInfo>(){

            public EntityInfo answer(InvocationOnMock invocation) throws Throwable {
                int index = (Integer)invocation.getArguments()[0];
                return (EntityInfo)LazyIteratorTest.this.entityInfos.get(index);
            }
        });
        this.iterator = new LazyIterator(this.extractor, (QueryResultLoader)new EntityLoader(this.cache, new KeyTransformationHandler()), this.getFetchSize());
    }

    @Override
    @AfterMethod(alwaysRun=false)
    public void tearDown() {
        this.iterator.close();
        ((DocumentExtractor)Mockito.verify((Object)this.extractor)).close();
        super.tearDown();
    }
}

