/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.backend.IndexModificationStrategy;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.query.clustered.QueryBox;
import org.infinispan.query.dsl.embedded.impl.JPACacheEventFilterConverter;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.CommandInitializer;
import org.infinispan.query.impl.IndexPropertyInspector;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.query.impl.externalizers.ClusteredTopDocsExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.LuceneBooleanQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneBytesRefExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFieldDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneMatchAllQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneScoreDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortFieldExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopFieldDocsExternalizer;
import org.infinispan.query.impl.massindex.DistributedExecutorMassIndexer;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.logging.Log;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.LogFactory;

public class LifecycleManager
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private static final Object REMOVED_REGISTRY_COMPONENT = new Object();
    private MBeanServer mbeanServer;
    private String jmxDomain;
    private static final Set<String> DEFAULT_CACHES = CollectionFactory.makeSet((Object[])new String[]{"LuceneIndexesLocking", "LuceneIndexesData", "LuceneIndexesMetadata"});

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        cr.registerComponent((Object)new ReflectionMatcher(null), ReflectionMatcher.class);
        if (cfg.indexing().index().isEnabled()) {
            log.registeringQueryInterceptor();
            SearchIntegrator searchFactory = this.getSearchFactory((Properties)cfg.indexing().properties(), cr);
            this.createQueryInterceptorIfNeeded(cr, cfg, searchFactory);
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)cr.getGlobalComponentRegistry().getComponent(EmbeddedCacheManager.class);
            this.addCacheDependencyIfNeeded(cacheName, cacheManager, (Properties)cfg.indexing().properties());
        }
    }

    private void addCacheDependencyIfNeeded(String cacheStarting, EmbeddedCacheManager cacheManager, Properties properties) {
        if (!"__cluster_registry_cache__".equals(cacheStarting)) {
            cacheManager.addCacheDependency(cacheStarting, "__cluster_registry_cache__");
        }
        if (IndexPropertyInspector.hasInfinispanDirectory(properties) && !DEFAULT_CACHES.contains(cacheStarting)) {
            String metadataCacheName = IndexPropertyInspector.getMetadataCacheName(properties);
            String lockingCacheName = IndexPropertyInspector.getLockingCacheName(properties);
            String dataCacheName = IndexPropertyInspector.getDataCacheName(properties);
            if (!metadataCacheName.equals(cacheStarting)) {
                cacheManager.addCacheDependency(cacheStarting, metadataCacheName);
            }
            if (!lockingCacheName.equals(cacheStarting)) {
                cacheManager.addCacheDependency(cacheStarting, lockingCacheName);
            }
            if (!dataCacheName.equals(cacheStarting)) {
                cacheManager.addCacheDependency(cacheStarting, dataCacheName);
            }
        }
    }

    private void createQueryInterceptorIfNeeded(ComponentRegistry cr, Configuration cfg, SearchIntegrator searchFactory) {
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor == null) {
            queryInterceptor = this.buildQueryInterceptor(cfg, searchFactory);
            InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(cfg);
            InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
            interceptorBuilder.interceptor((CommandInterceptor)queryInterceptor);
            if (!cfg.transaction().transactionMode().isTransactional()) {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, NonTransactionalLockingInterceptor.class);
                }
                interceptorBuilder.after(NonTransactionalLockingInterceptor.class);
            } else if (cfg.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, OptimisticLockingInterceptor.class);
                }
                interceptorBuilder.after(OptimisticLockingInterceptor.class);
            } else {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, PessimisticLockingInterceptor.class);
                }
                interceptorBuilder.after(PessimisticLockingInterceptor.class);
            }
            if (ic != null) {
                cr.registerComponent((Object)queryInterceptor, QueryInterceptor.class);
                cr.registerComponent((Object)queryInterceptor, ((Object)((Object)queryInterceptor)).getClass().getName(), true);
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    private QueryInterceptor buildQueryInterceptor(Configuration cfg, SearchIntegrator searchFactory) {
        IndexModificationStrategy indexingStrategy = IndexModificationStrategy.configuredStrategy(searchFactory, cfg);
        return new QueryInterceptor(searchFactory, indexingStrategy);
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        boolean indexingEnabled = configuration.indexing().index().isEnabled();
        if (!indexingEnabled) {
            if (this.verifyChainContainsQueryInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the Query interceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
        Cache cache = (Cache)cr.getComponent(Cache.class);
        CommandInitializer initializer = (CommandInitializer)cr.getComponent(CommandInitializer.class);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)cr.getGlobalComponentRegistry().getComponent(EmbeddedCacheManager.class);
        initializer.setCacheManager(cacheManager);
        QueryBox queryBox = new QueryBox();
        queryBox.setCache(cache.getAdvancedCache());
        cr.registerComponent((Object)queryBox, QueryBox.class);
        this.registerQueryMBeans(cache.getAdvancedCache(), cr, cacheName);
    }

    private void registerQueryMBeans(AdvancedCache cache, ComponentRegistry cr, String cacheName) {
        Configuration cfg = cache.getCacheConfiguration();
        SearchIntegrator sf = this.getSearchFactory((Properties)cfg.indexing().properties(), cr);
        GlobalConfiguration globalCfg = cr.getGlobalComponentRegistry().getGlobalConfiguration();
        this.mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
        String cacheManagerName = cr.getGlobalComponentRegistry().getGlobalConfiguration().globalJmxStatistics().cacheManagerName();
        String queryGroupName = this.getQueryGroupName(cacheManagerName, cacheName);
        this.jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer, (String)queryGroupName);
        InfinispanQueryStatisticsInfo stats = new InfinispanQueryStatisticsInfo(sf);
        stats.setStatisticsEnabled(cfg.jmxStatistics().enabled());
        try {
            ObjectName statsObjName = new ObjectName(this.jmxDomain + ":" + queryGroupName + ",component=Statistics");
            JmxUtil.registerMBean((Object)stats, (ObjectName)statsObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register query module statistics mbean", (Throwable)e);
        }
        ManageableComponentMetadata massIndexerCompMetadata = cr.getGlobalComponentRegistry().getComponentMetadataRepo().findComponentMetadata(MassIndexer.class).toManageableComponentMetadata();
        try {
            DistributedExecutorMassIndexer maxIndexer = new DistributedExecutorMassIndexer(cache, sf);
            ResourceDMBean mbean = new ResourceDMBean((Object)maxIndexer, massIndexerCompMetadata);
            ObjectName massIndexerObjName = new ObjectName(this.jmxDomain + ":" + queryGroupName + ",component=" + massIndexerCompMetadata.getJmxObjectName());
            JmxUtil.registerMBean((Object)mbean, (ObjectName)massIndexerObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to create ", (Throwable)e);
        }
    }

    private String getQueryGroupName(String cacheManagerName, String cacheName) {
        return "type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName);
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        InterceptorChain interceptorChain = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        return interceptorChain.containsInterceptorType(QueryInterceptor.class, true);
    }

    private SearchIntegrator getSearchFactory(Properties indexingProperties, ComponentRegistry cr) {
        Object component = cr.getComponent(SearchIntegrator.class);
        SearchIntegrator searchFactory = null;
        if (component instanceof SearchIntegrator) {
            searchFactory = (SearchIntegrator)component;
        }
        if (searchFactory == null) {
            GlobalComponentRegistry globalComponentRegistry = cr.getGlobalComponentRegistry();
            EmbeddedCacheManager uninitializedCacheManager = (EmbeddedCacheManager)globalComponentRegistry.getComponent(EmbeddedCacheManager.class);
            indexingProperties = this.addProgrammaticMappings(indexingProperties, cr);
            SearchableCacheConfiguration config = new SearchableCacheConfiguration(new Class[0], indexingProperties, uninitializedCacheManager, cr);
            searchFactory = new SearchFactoryBuilder().configuration((SearchConfiguration)config).buildSearchFactory();
            cr.registerComponent((Object)searchFactory, SearchIntegrator.class);
        }
        return searchFactory;
    }

    private Properties addProgrammaticMappings(Properties indexingProperties, ComponentRegistry cr) {
        Iterator providers = ServiceFinder.load(ProgrammaticSearchMappingProvider.class, (ClassLoader[])new ClassLoader[0]).iterator();
        if (providers.hasNext()) {
            SearchMapping mapping = (SearchMapping)indexingProperties.get("hibernate.search.model_mapping");
            if (mapping == null) {
                mapping = new SearchMapping();
                Properties amendedProperties = new Properties();
                amendedProperties.putAll((Map<?, ?>)indexingProperties);
                amendedProperties.put("hibernate.search.model_mapping", mapping);
                indexingProperties = amendedProperties;
            }
            Cache cache = (Cache)cr.getComponent(Cache.class);
            while (providers.hasNext()) {
                ProgrammaticSearchMappingProvider provider = (ProgrammaticSearchMappingProvider)providers.next();
                if (log.isDebugEnabled()) {
                    log.debugf("Loading programmatic search mappings for cache %s from provider : %s", cache.getName(), provider.getClass().getName());
                }
                provider.defineMappings(cache, mapping);
            }
        }
        return indexingProperties;
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        Object searchFactoryIntegrator;
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor != null) {
            queryInterceptor.prepareForStopping();
        }
        if ((searchFactoryIntegrator = cr.getComponent(SearchIntegrator.class)) != null && searchFactoryIntegrator != REMOVED_REGISTRY_COMPONENT) {
            ((SearchIntegrator)searchFactoryIntegrator).close();
            cr.registerComponent(REMOVED_REGISTRY_COMPONENT, SearchIntegrator.class);
        }
        if (this.mbeanServer != null) {
            String cacheManagerName = cr.getGlobalComponentRegistry().getGlobalConfiguration().globalJmxStatistics().cacheManagerName();
            String queryMBeanFilter = this.jmxDomain + ":" + this.getQueryGroupName(cacheManagerName, cacheName) + ",*";
            JmxUtil.unregisterMBeans((String)queryMBeanFilter, (MBeanServer)this.mbeanServer);
        }
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.removeQueryInterceptorFromConfiguration(cfg);
    }

    private void removeQueryInterceptorFromConfiguration(Configuration cfg) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        CustomInterceptorsConfigurationBuilder customInterceptorsBuilder = builder.customInterceptors();
        for (InterceptorConfiguration interceptorConfig : cfg.customInterceptors().interceptors()) {
            if (interceptorConfig.interceptor() instanceof QueryInterceptor) continue;
            customInterceptorsBuilder.addInterceptor().read(interceptorConfig);
        }
        cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        QueryCache queryCache = new QueryCache();
        gcr.registerComponent((Object)queryCache, QueryCache.class);
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.JPA_FILTER_AND_CONVERTER, new JPAFilterAndConverter.JPAFilterAndConverterExternalizer());
        externalizerMap.put(ExternalizerIds.JPA_FILTER_RESULT, new JPAFilterAndConverter.FilterResultExternalizer());
        externalizerMap.put(ExternalizerIds.JPA_CACHE_EVENT_FILTER_CONVERTER, new JPACacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_BOOLEAN, new LuceneBooleanQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_TERM, new LuceneTermQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TERM, new LuceneTermExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT, new LuceneSortExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT_FIELD, new LuceneSortFieldExternalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_TOPDOCS, new ClusteredTopDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPDOCS, new LuceneTopDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_FIELD_SCORE_DOC, new LuceneFieldDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SCORE_DOC, new LuceneScoreDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPFIELDDOCS, new LuceneTopFieldDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_MATCH_ALL, new LuceneMatchAllQueryExternalizer());
        externalizerMap.put(ExternalizerIds.INDEX_WORKER, new IndexWorker.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_BYTES_REF, new LuceneBytesRefExternalizer());
    }
}

