/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.util.HashSet;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.continuous.ContinuousQuery;
import org.infinispan.query.continuous.ContinuousQueryResultListener;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.continuous.ContinuousQueryTest")
public class ContinuousQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cacheConfiguration = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cacheConfiguration);
    }

    public void testContinuousQuery() {
        Person value;
        int i;
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        ContinuousQuery cq = new ContinuousQuery(this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)30).toBuilder().build();
        final HashSet joined = new HashSet();
        final HashSet left = new HashSet();
        ContinuousQueryResultListener<Object, Object> listener = new ContinuousQueryResultListener<Object, Object>(){

            public void resultJoining(Object key, Object value) {
                joined.add(key);
            }

            public void resultLeaving(Object key) {
                left.add(key);
            }
        };
        cq.addContinuousQueryListener(query, (ContinuousQueryResultListener)listener);
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(40);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)6L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        joined.clear();
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 40);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)left.size());
        left.clear();
        for (i = 4; i < 20; ++i) {
            this.cache().remove((Object)i);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)left.size());
        left.clear();
        this.cache().clear();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)left.size());
        left.clear();
        cq.removeContinuousQueryListener((ContinuousQueryResultListener)listener);
        for (i = 0; i < 3; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 20);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
    }
}

